<?php
/**
* Upgrade de MercadoPago
*
* @author     Modulo MercadoPago>
* @copyright Kubo Digital
* @license   Comercial
*/

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_4_0_1($mp)
{
    if (!$mp || $mp->name != 'mpmxs') {
        $mp = Module::getInstanceByName('mpmxs');
    }
    MercadoPagoGatewayKijamMpmxs::log('upgrade_module_4_0_1 init...');
    
    $mp_prefix = 'MPMX_';
    if (version_compare(_PS_VERSION_, '1.5.0.9') >= 0) {
        $actual_context = Shop::getContext();
        Shop::setContext(Shop::CONTEXT_ALL);
        $shops = Shop::getContextListShopID();
        foreach ($shops as $id_shop) {
            $id_shop_group = (int)Shop::getGroupFromShop($id_shop, true);
            
            $mp_max_installments = (int)Configuration::get(
                $mp_prefix.'MAX_INSTALLMENTS',
                null,
                $id_shop_group,
                $id_shop
            );
            $mp_min_amount_installments = (int)Configuration::get(
                $mp_prefix.'MIN_AMOUNT_INSTALLMENTS',
                null,
                $id_shop_group,
                $id_shop
            );
            $mp_modal_active = (int)Configuration::get($mp_prefix.'MODAL', null, $id_shop_group, $id_shop);
            $mp_client_id = Configuration::get($mp_prefix.'CLIENT_ID', null, $id_shop_group, $id_shop);
            $mp_client_secret = Configuration::get($mp_prefix.'CLIENT_SECRET', null, $id_shop_group, $id_shop);
            $mp_fee = (float)Configuration::get($mp_prefix.'FEE', null, $id_shop_group, $id_shop);
            $mp_style = (array)Tools::jsonDecode(Configuration::get(
                $mp_prefix.'STYLE',
                null,
                $id_shop_group,
                $id_shop
            ), true);
            $mp_payments = (array)Tools::jsonDecode(Configuration::get(
                $mp_prefix.'PAYMENTS',
                null,
                $id_shop_group,
                $id_shop
            ), true);
            $mp_status_refound = (array)Tools::jsonDecode(Configuration::get(
                $mp_prefix.'STATUS_REFOUND',
                null,
                $id_shop_group,
                $id_shop
            ), true);
            $config = array();
            $config['os_authorization'] = (int)Configuration::get('PS_OS_PAYMENT');
            $config['os_refused'] = (int)Configuration::get('PS_OS_ERROR');
            $config['status_refound'] = $mp_status_refound;
            $config['min_amount_installments'] = $mp_min_amount_installments;
            $config['max_installments'] = $mp_max_installments;
            $config['modal'] = $mp_modal_active;
            $config['client_id'] = $mp_client_id;
            $config['client_id'] = $mp_client_id;
            $config['client_secret'] = $mp_client_secret;
            $config['fee'] = $mp_fee;
            $config['fee_amount'] = 0;
            $config['style'] = $mp_style;
            $config['exclude_payments'] = $mp_payments;
            $config['auto_return'] = true;
            $config['image_for_order'] = 'product';
            
            if (version_compare(_PS_VERSION_, '1.5.0.5') < 0) {
                $config['logo_mercadopago_checkout'] = Tools::getHttpHost(true, true)._PS_IMG_.'logo.jpg';
            } else {
                $link = new Link();
                if ((bool)Configuration::get('PS_SSL_ENABLED')) {
                    $config['logo_mercadopago_checkout'] = 'https://'.preg_replace(
                        '/https?:\/\//i',
                        '',
                        $link->getMediaLink(_PS_IMG_.Configuration::get('PS_LOGO'))
                    );
                } else {
                    $config['logo_mercadopago_checkout'] = 'http://'.preg_replace(
                        '/https?:\/\//i',
                        '',
                        $link->getMediaLink(_PS_IMG_.Configuration::get('PS_LOGO'))
                    );
                }
            }
            Configuration::updateValue(
                $mp->name.'kijam_os_pending',
                (int)Configuration::get($mp_prefix.'OS_PENDING'),
                false,
                $id_shop_group,
                $id_shop
            );
            Configuration::updateValue(
                $mp->name.'kijam_config',
                Tools::jsonEncode($config),
                false,
                $id_shop_group,
                $id_shop
            );
            Configuration::updateValue(
                $mp->name.'kijam_os_pending',
                (int)Configuration::get($mp_prefix.'OS_PENDING', null, $id_shop_group, $id_shop),
                false,
                $id_shop_group,
                $id_shop
            );
        }
        Shop::setContext($actual_context);
        Configuration::updateValue(
            $mp->name.'kijam_os_pending',
            (int)Configuration::get($mp_prefix.'OS_PENDING')
        );
    } else {
        $mp_max_installments = (int)Configuration::get($mp_prefix.'MAX_INSTALLMENTS');
        $mp_min_amount_installments = (int)Configuration::get($mp_prefix.'MIN_AMOUNT_INSTALLMENTS');
        $mp_modal_active = (int)Configuration::get($mp_prefix.'MODAL');
        $mp_client_id = Configuration::get($mp_prefix.'CLIENT_ID');
        $mp_client_secret = Configuration::get($mp_prefix.'CLIENT_SECRET');
        $mp_fee = (float)Configuration::get($mp_prefix.'FEE');
        $mp_style = (array)Tools::jsonDecode(Configuration::get($mp_prefix.'STYLE'), true);
        $mp_payments = (array)Tools::jsonDecode(Configuration::get($mp_prefix.'PAYMENTS'), true);
        $mp_status_refound = (array)Tools::jsonDecode(Configuration::get(
            $mp_prefix.'STATUS_REFOUND'
        ), true);
        $config = array();
        $config['os_authorization'] = (int)Configuration::get('PS_OS_PAYMENT');
        $config['os_refused'] = (int)Configuration::get('PS_OS_ERROR');
        $config['status_refound'] = $mp_status_refound;
        $config['max_installments'] = $mp_max_installments;
        $config['min_amount_installments'] = $mp_min_amount_installments;
        $config['modal'] = $mp_modal_active;
        $config['client_id'] = $mp_client_id;
        $config['client_secret'] = $mp_client_secret;
        $config['fee'] = $mp_fee;
        $config['fee_amount'] = 0;
        $config['style'] = $mp_style;
        $config['exclude_payments'] = $mp_payments;
        $config['auto_return'] = true;
        
        if (version_compare(_PS_VERSION_, '1.5.0.5') < 0) {
            $config['logo_mercadopago_checkout'] = Tools::getHttpHost(true, true)._PS_IMG_.'logo.jpg';
        } else {
            $link = new Link();
            if ((bool)Configuration::get('PS_SSL_ENABLED')) {
                $config['logo_mercadopago_checkout'] = 'https://'.preg_replace(
                    '/https?:\/\//i',
                    '',
                    $link->getMediaLink(_PS_IMG_.Configuration::get('PS_LOGO'))
                );
            } else {
                $config['logo_mercadopago_checkout'] = 'http://'.preg_replace(
                    '/https?:\/\//i',
                    '',
                    $link->getMediaLink(_PS_IMG_.Configuration::get('PS_LOGO'))
                );
            }
        }
        Configuration::updateValue(
            $mp->name.'kijam_config',
            Tools::jsonEncode($config)
        );
        Configuration::updateValue(
            $mp->name.'kijam_os_pending',
            (int)Configuration::get($mp_prefix.'OS_PENDING')
        );
    }
    Configuration::deleteByName($mp_prefix.'STATUS_REFOUND');
    Configuration::deleteByName($mp_prefix.'CARRIER');
    Configuration::deleteByName($mp_prefix.'SHIPPING_MODE');
    Configuration::deleteByName($mp_prefix.'SHIPPING_ACTIVE');
    Configuration::deleteByName($mp_prefix.'SHIP_CHECK_PRICE');
    Configuration::deleteByName($mp_prefix.'WIDTH');
    Configuration::deleteByName($mp_prefix.'HEIGHT');
    Configuration::deleteByName($mp_prefix.'DEPTH');
    Configuration::deleteByName($mp_prefix.'WEIGHT');
    Configuration::deleteByName($mp_prefix.'FREE_SHIPPING');
    Configuration::deleteByName($mp_prefix.'OS_AUTHORIZATION');
    Configuration::deleteByName($mp_prefix.'OS_PENDING');
    Configuration::deleteByName($mp_prefix.'OS_REFUSED');
    Configuration::deleteByName($mp_prefix.'SANDBOX');
    Configuration::deleteByName($mp_prefix.'MODAL');
    Configuration::deleteByName($mp_prefix.'CLIENT_ID');
    Configuration::deleteByName($mp_prefix.'CLIENT_SECRET');
    Configuration::deleteByName($mp_prefix.'FEE');
    Configuration::deleteByName($mp_prefix.'VALIDATION');
    Configuration::deleteByName($mp_prefix.'STYLE');
    Configuration::deleteByName($mp_prefix.'TEST_USER');
    Db::getInstance()->Execute('  ALTER TABLE 
                                    `'.bqSQL(_DB_PREFIX_.$mp->name).'`
                                  RENAME `'.bqSQL(_DB_PREFIX_).'mpk`');
    Db::getInstance()->Execute('  ALTER TABLE
                                    `'.bqSQL(_DB_PREFIX_.$mp->name).'_refunds`
                                  RENAME `'.bqSQL(_DB_PREFIX_).'mpk_refunds`');
    Db::getInstance()->Execute('CREATE TABLE IF NOT EXISTS
        `'.bqSQL(_DB_PREFIX_).'mpk_cache` (
        `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
        `cache_id` varchar(100) NOT NULL,
        `data` LONGTEXT NOT NULL,
        `ttl` INT(11) NOT NULL,
        UNIQUE(cache_id),
        INDEX(ttl)
        )');
    MercadoPagoGatewayKijamMpmxs::log('upgrade_module_4_0_1 end!');
    return true;
}
