<?php
/**
* Modulo MercadoPago
*
* @author     Modulo MercadoPago>
* @copyright Kubo Digital
* @license   Commercial use allowed (Non-assignable & non-transferable), can modify source-code but cannot distribute modifications (derivative works).
*/

class MercadoPagoGatewayKijamMpmxs
{
    //Constantes
    const DB_PREFIX = 'mpmxss';
    const STATUS_PREFIX = 'MPK_';

    //Configuracion general del modulo
    private $settings = null;
    private $config = null;
    private $os_pending = null;
    private $test_user = null;
    private $test_user_retry = null;
    private $list_shippings = array('mp_ps'=>array(), 'ps_mp'=>array());
    private $currency_convert = array();
    private $site_id = null;
    private $site_url = null;
    private $id_shop = null;
    private $id_shop_group = null;
    private $module_name = null;
    private $instance_module = null;
    private $api = null;
    private $api_me = null;
    private $mercadoenvios_available = false;
    private $context = null;
    private static $dimensionUnit = '';
    private static $weightUnit = '';
    private $dimensionUnitList = array('CM' => 'CM', 'IN' => 'IN', 'CMS' => 'CM', 'INC' => 'IN');
    private $weightUnitList = array('KG' => 'KGS', 'KGS' => 'KGS', 'LBS' => 'LBS', 'LB' => 'LBS');
    public $warning = '';

    //Propiedades estaticas
    private static $instance = null;
    private static $instance_status = 'uninstance';
    private static $mp_cache = array();
    private static $ignore_update_status = false;

    private function __construct($load_site_id, $load_module_name, $load_instance_module)
    {
        if (!defined('_PS_VERSION_')) {
            exit;
        }
        if (!class_exists('MercadoPagoGenericMpmxs')) {
            require_once(dirname(__FILE__).'/lib/mercadopagogeneric.php');
        }
        if (!class_exists('MpMutex')) {
            require_once(dirname(__FILE__).'/lib/mpmutex.php');
        }
        $data = include(dirname(__FILE__).'/data-mp-countries.php');
        $this->context = Context::getContext();
        $this->site_id = $load_site_id;
        $this->module_name = $load_module_name;
        $this->instance_module = $load_instance_module;
        $this->settings = $data[Tools::strtoupper($this->site_id)];
        $this->site_url = Tools::htmlentitiesutf8(
            ((bool)Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://')
            .$_SERVER['HTTP_HOST'].__PS_BASE_URI__
        );
        self::$instance = $this;
        if (version_compare(_PS_VERSION_, '1.5.0.9') >= 0) {
            $this->id_shop = Shop::getContextShopID();
            $this->id_shop_group = Shop::getContextShopGroupID();
            if ((int)$this->id_shop > 0) {
                $shop = new Shop($this->id_shop);
                $this->site_url = (bool)Configuration::get('PS_SSL_ENABLED')?'https://'.$shop->domain_ssl:'http://'
                                    .$shop->domain;
                $this->site_url .= $shop->getBaseURI(true);
            }
            $config2 = Configuration::get(
                $this->module_name.'kijam_config',
                null,
                $this->id_shop_group,
                $this->id_shop
            );
            //echo var_dump($config2);
            $this->config = (array)Tools::jsonDecode($config2, true);
            //echo var_dump($this->config);
            $this->list_shippings = (array)Tools::jsonDecode(Configuration::get(
                $this->module_name.'kijam_list_shippings',
                null,
                $this->id_shop_group,
                $this->id_shop
            ), true);
            $this->test_user = (array)Tools::jsonDecode(Configuration::get(
                $this->module_name.'kijam_test_user',
                null,
                $this->id_shop_group,
                $this->id_shop
            ), true);
            $this->test_user_retry = (int)Configuration::get(
                $this->module_name.'kijam_test_user_retry',
                null,
                $this->id_shop_group,
                $this->id_shop
            );
            $this->currency_convert = (array)Tools::jsonDecode(Configuration::get(
                $this->module_name.'kijam_currency_convert',
                null,
                $this->id_shop_group,
                $this->id_shop
            ), true);
            $this->os_pending = (int)Configuration::get(
                $this->module_name.'kijam_os_pending',
                null,
                $this->id_shop_group,
                $this->id_shop
            );
        } else {
            $this->config = (array)Tools::jsonDecode(Configuration::get($this->module_name.'kijam_config'), true);
            $this->list_shippings = (array)Tools::jsonDecode(
                Configuration::get($this->module_name.'kijam_list_shippings'),
                true
            );
            $this->test_user = (array)Tools::jsonDecode(Configuration::get($this->module_name.'kijam_test_user'), true);
            $this->test_user_retry = (int)Configuration::get($this->module_name.'kijam_test_user_retry');
            $this->currency_convert = (array)Tools::jsonDecode(
                Configuration::get($this->module_name.'kijam_currency_convert'),
                true
            );
            $this->os_pending = (int)Configuration::get($this->module_name.'kijam_os_pending');
        }
        if (isset($this->config['client_id']) && isset($this->config['client_secret'])) {
            $this->api = new MercadoPagoGenericMpmxs($this->config['client_id'], $this->config['client_secret']);
            $this->verifyOrderStatus();
            $this->verifyMercadoPago();
            if ($this->api_me) {
                if ($this->api_me['site_id'] != $this->site_id) {
                    $this->api_me = null;
                    $this->api = null;
                } else {
                    $this->verifyTestUser();
                }
            }
            if (!isset($this->config['fee'])) {
                $this->config['os_authorization'] = (int)Configuration::get('PS_OS_PAYMENT');
                $this->config['os_refused'] = (int)Configuration::get('PS_OS_ERROR');
                $this->config['status_refound'] = array(
                    (int)Configuration::get('PS_OS_CANCELED'),
                    (int)Configuration::get('PS_OS_REFUND')
                );
                $this->config['max_installments'] = 24;
                $this->config['min_amount_installments'] = 0;
                $this->config['fee'] = 0;
                $this->config['fee_amount'] = 0;
                
                $this->config['auto_return'] = true;
                $this->config['logo_mercadopago_checkout_size'] = false;
                if (version_compare(_PS_VERSION_, '1.5.0.5') < 0) {
                    $this->config['logo_mercadopago_checkout'] = Tools::getHttpHost(true, true)._PS_IMG_.'logo.jpg';
                } else {
                    $link = new Link();
                    if ((bool)Configuration::get('PS_SSL_ENABLED')) {
                        $this->config['logo_mercadopago_checkout'] = 'https://'.preg_replace(
                            '/https?:\/\//i',
                            '',
                            $link->getMediaLink(_PS_IMG_.Configuration::get('PS_LOGO'))
                        );
                    } else {
                        $this->config['logo_mercadopago_checkout'] = 'http://'.preg_replace(
                            '/https?:\/\//i',
                            '',
                            $link->getMediaLink(_PS_IMG_.Configuration::get('PS_LOGO'))
                        );
                    }
                }
            }
        }
        if (!isset($this->config['style']) || !isset($this->config['style']['b_color'])) {
            $this->config['style'] = array(
                'b_color' => 'blue',
                'b_size' => 'M',
                'b_shape' => 'Ov',
                'b_font' => 'Ar',
                'b_logo' => 'On',
            );
        }
        if (isset($this->settings['MPENVIOS_REGISTER_URL'])) {
        } else {
            $this->config['shipping_active'] = false;
            $this->mercadoenvios_available = false;
        }
    }
    public static function getInstance($load_site_id, $load_module_name, $load_instance_module)
    {
        if (is_null(self::$instance) && self::$instance_status == 'uninstance') {
            self::$instance_status = 'loading';
            self::$instance = new MercadoPagoGatewayKijamMpmxs($load_site_id, $load_module_name, $load_instance_module);
            self::$instance_status = 'loaded';
        }
        return self::$instance;
    }
    public function installDb()
    {
         $db_created = Db::getInstance()->Execute('CREATE TABLE IF NOT EXISTS `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'` (
                `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
                `id_order` INT(11) NOT NULL,
                `id_shop` INT(11) NOT NULL,
                `topic` varchar(100) NOT NULL,
                `mp_op_id` varchar(100) NOT NULL,
                `is_sandbox` TINYINT(1) NOT NULL DEFAULT 0,
                `status` INT(11) NOT NULL,
                `next_retry` INT(11) NOT NULL,
                UNIQUE(mp_op_id),
                INDEX(id_order),
                INDEX(id_shop),
                INDEX(next_retry, status)
                )');

        $db_created = $db_created && Db::getInstance()->Execute('CREATE TABLE IF NOT EXISTS
                    `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'_refunds` (
                `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
                `id_order` INT(11) NOT NULL,
                `mp_op_id` varchar(100) NOT NULL,
                `date_create` DATETIME NOT NULL,
                `response` TEXT NOT NULL,
                INDEX(id_order),
                INDEX(mp_op_id)
                )');
        $db_created = $db_created && Db::getInstance()->Execute('CREATE TABLE IF NOT EXISTS
                        `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'_cache` (
                    `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
                    `cache_id` varchar(100) NOT NULL,
                    `data` LONGTEXT NOT NULL,
                    `ttl` INT(11) NOT NULL,
                    UNIQUE(cache_id),
                    INDEX(ttl)
                    )');
        return $db_created;
    }
    public function uninstall()
    {
        if ((int)$this->os_pending > 0) {
            $order_state = new OrderState((int)$this->os_pending);
            @unlink(dirname(__FILE__).'/../../img/os/'.(int)$order_state->id.'.gif');
            $order_state->delete();
        }
        
        Configuration::deleteByName($this->module_name.'kijam_config');
        Configuration::deleteByName($this->module_name.'kijam_test_user');
        Configuration::deleteByName($this->module_name.'kijam_test_user_retry');
        Configuration::deleteByName($this->module_name.'kijam_os_pending');
        Configuration::deleteByName($this->module_name.'kijam_currency_convert');
        Db::getInstance()->Execute('DROP TABLE IF EXISTS `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`');
        Db::getInstance()->Execute('DROP TABLE IF EXISTS `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'_refunds`');
        Db::getInstance()->Execute('DROP TABLE IF EXISTS `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'_cache`');
    }
    public function getConfig()
    {
        return $this->config;
    }
    public function getSettings()
    {
        return $this->settings;
    }
    /*******************************************************/
    /*******************************************************/
    /******** DESDE AQUI VA TODO LO RELACIONADO ************/
    /******************* A MERCADOPAGO *********************/
    /*******************************************************/
    /*******************************************************/
    public function verifyOrderStatus()
    {
        if ((int)$this->os_pending > 0) {
            $order_state = new OrderState((int)$this->os_pending);
            if ($order_state && (int)$order_state->id > 0 && !$order_state->deleted) {
                return;
            }
        }

        $order_state = new OrderState();
        $order_state->name = array();
        foreach (Language::getLanguages() as $language) {
            $order_state->name[$language['id_lang']] = 'Verificando Pago';
        }

        $order_state->send_email = false;
        $order_state->color = '#DDEEFF';
        $order_state->hidden = false;
        $order_state->delivery = false;
        $order_state->logable = false;
        if (version_compare(_PS_VERSION_, '1.5.0.1') > 0) {
            $order_state->paid = false;
        }
        $order_state->invoice = false;
        if ($order_state->add()) {
            $source = dirname(__FILE__).'/view/img/state_ms_2.gif';
            $destination = dirname(__FILE__).'/../../img/os/'.(int)$order_state->id.'.gif';
            @copy($source, $destination);
        }
        $this->os_pending = (int)$order_state->id;
        Configuration::updateValue($this->module_name.'kijam_os_pending', $this->os_pending);
        if (version_compare(_PS_VERSION_, '1.5.0.9') >= 0) {
            $actual_context = Shop::getContext();
            Shop::setContext(Shop::CONTEXT_ALL);
            $shops = Shop::getContextListShopID();
            $shop_groups_list = array();

            /* Setup each shop */
            foreach ($shops as $shop_id) {
                $shop_group_id = (int)Shop::getGroupFromShop($shop_id, true);

                if (!in_array($shop_group_id, $shop_groups_list)) {
                    $shop_groups_list[] = $shop_group_id;
                }
                /* Sets up configuration */
                Configuration::updateValue(
                    $this->module_name.'kijam_os_pending',
                    $this->os_pending,
                    false,
                    $shop_group_id,
                    $shop_id
                );
            }

            /* Sets up Shop Group configuration */
            if (count($shop_groups_list)) {
                foreach ($shop_groups_list as $shop_group_id) {
                    Configuration::updateValue(
                        $this->module_name.'kijam_os_pending',
                        $this->os_pending,
                        false,
                        $shop_group_id
                    );
                }
            }
            Shop::setContext($actual_context);
        }
    }
    public function verifyTestUser()
    {
        $test_user = $this->test_user;
        if ($this->api_me && (!$test_user || !isset($test_user['time'])/* || $test_user['time'] + 4320000 < time()*/)) {
            if (time() < $this->test_user_retry) {
                return;
            }
            $test_user = array();
            $test_user_s = $this->api->get_test_user($this->site_id);
            if (isset($test_user_s['status']) && $test_user_s['status'] < 400) {
                $test_user_b = $this->api->get_test_user($this->site_id);
                if (isset($test_user_b['status']) && $test_user_b['status'] < 400) {
                    $test_user['time'] = time();
                    $test_user['seller'] = $test_user_s['response'];
                    $test_user['buyer'] = $test_user_b['response'];
                    self::log('New Test User: '.print_r($test_user, true));
                }
            } else {
                self::log('Error Creating New Test User: '.print_r($test_user_s, true));
            }
            if (isset($test_user['time'])) {
                $this->test_user = $test_user;
                Configuration::updateValue($this->module_name.'kijam_test_user', Tools::jsonEncode($test_user));
                if (version_compare(_PS_VERSION_, '1.5.0.9') >= 0) {
                    $actual_context = Shop::getContext();
                    Shop::setContext(Shop::CONTEXT_ALL);
                    $shops = Shop::getContextListShopID();
                    $shop_groups_list = array();
                    /* Setup each shop */
                    foreach ($shops as $shop_id) {
                        $shop_group_id = (int)Shop::getGroupFromShop($shop_id, true);
                        if (!in_array($shop_group_id, $shop_groups_list)) {
                            $shop_groups_list[] = $shop_group_id;
                        }
                        Configuration::updateValue(
                            $this->module_name.'kijam_test_user',
                            Tools::jsonEncode($test_user),
                            false,
                            $shop_group_id,
                            $shop_id
                        );
                    }

                    /* Sets up Shop Group configuration */
                    if (count($shop_groups_list)) {
                        foreach ($shop_groups_list as $shop_group_id) {
                            Configuration::updateValue(
                                $this->module_name.'kijam_test_user',
                                Tools::jsonEncode($test_user),
                                false,
                                $shop_group_id
                            );
                        }
                    }
                    Shop::setContext($actual_context);
                }
            } else {
                Configuration::updateValue($this->module_name.'kijam_test_user_retry', time() + 60*60*24*7);
                if (version_compare(_PS_VERSION_, '1.5.0.9') >= 0) {
                    $actual_context = Shop::getContext();
                    Shop::setContext(Shop::CONTEXT_ALL);
                    $shops = Shop::getContextListShopID();
                    $shop_groups_list = array();
                    /* Setup each shop */
                    foreach ($shops as $shop_id) {
                        $shop_group_id = (int)Shop::getGroupFromShop($shop_id, true);
                        if (!in_array($shop_group_id, $shop_groups_list)) {
                            $shop_groups_list[] = $shop_group_id;
                        }
                        Configuration::updateValue(
                            $this->module_name.'kijam_test_user_retry',
                            time() + 60*60*24*7,
                            false,
                            $shop_group_id,
                            $shop_id
                        );
                    }
                    /* Sets up Shop Group configuration */
                    if (count($shop_groups_list)) {
                        foreach ($shop_groups_list as $shop_group_id) {
                            Configuration::updateValue(
                                $this->module_name.'kijam_test_user_retry',
                                time() + 60*60*24*7,
                                false,
                                $shop_group_id
                            );
                        }
                    }
                    Shop::setContext($actual_context);
                }
            }
        }
    }
    public function verifyMercadoPago($force_reload = false)
    {
        if (!isset($this->config['client_secret']) || !isset($this->config['client_secret'])) {
            return false;
        }
        if (!$force_reload && !is_null($this->api_me)) {
            return $this->api_me;
        }
        $cache_id = 'mp_me_'.md5($this->config['client_id'].'-'.$this->config['client_secret']);
        $me = false;
        if (!$force_reload && $me = self::getCache($cache_id)) {
            if (isset($me['status'])) {
                if ($me['status'] >= 400) {
                    self::log('ERROR-verifyMercadoPago: '.print_r($me, true));
                    return false;
                }
                if ($me && isset($me['response'])) {
                    $this->api_me = $me['response'];
                    return $me['response'];
                }
            }
        }
        try {
            if (!is_null($this->api)) {
                $me = $this->api->get_me();
                self::setCache($cache_id, $me);
                if (!$me || !isset($me['status']) || (int)$me['status'] >= 400) {
                    self::log('ERROR-verifyMercadoPago: '.print_r($me, true));
                    return false;
                }
                self::log('verifyMercadoPago: new cache '.$cache_id.' -> '.print_r($me, true));
                if (isset($me['response'])) {
                    $this->api_me = $me['response'];
                    return $me['response'];
                }
            }
        } catch (Exception $e) {
            self::log('ERROR-verifyMercadoPago: '.$e->getFile()."[".$e->getLine()."] -> ".$e->getMessage());
            return false;
        }
        return false;
    }
    public function getBalance()
    {
        $me = $this->verifyMercadoPago();
        if ($me) {
            $balance = $this->api->get_balance($me['id']);
            self::log('getBalance: '.print_r($balance, true));
            return $balance && isset($balance['response'])?$balance['response']:false;
        }
        return false;
    }
    public function validateMercadoPago($topic, $mp_op_id, $is_sandbox = -1)
    {
        if (!$mp_op_id || is_null($this->api)) {
            return false;
        }
        if ($is_sandbox == 0) {
            $this->api->sandbox_mode(false);
        } elseif ($is_sandbox == 1) {
            $this->api->sandbox_mode(true);
        } else {
            $this->api->sandbox_mode(false);
            $is_sandbox = false;
        }
        $this->verifyOrderStatus();
        $paid_amount = 0;
        $commision_amount = 0;
        $status_act = false;
        $merchant_order_info = false;
        $payment_info = false;
        $shipping_info = false;
        $ret = array();
        $ret['shipment_ids'] = array();
        if ($topic == null || !$topic || Tools::strlen($topic) < 1 || $topic == 'payment') {
            try {
                $payment_info = $this->api->get_payment_info($mp_op_id);
                if ($payment_info['status'] >= 400) {
                    self::log('ERROR-validateMercadoPago['.$mp_op_id.']->get_payment_info:
                    '.print_r($payment_info, true));
                    return false;
                }
            } catch (Exception $e) {
                self::log('ERROR-validateMercadoPago['.$mp_op_id.']->get_payment_info: 
                            '.$e->getFile()."[".$e->getLine()."] -> ".$e->getMessage());
                return false;
            }
            self::log('validateMercadoPago['.$mp_op_id.']->get_payment_info: '.print_r($payment_info, true));
            if (isset($payment_info['response']) && isset($payment_info['response']['collection'])) {
                $payment_info = $payment_info['response']['collection'];
                try {
                    if (isset($payment_info['merchant_order_id'])) {
                        $merchant_order_info = $this->api->get_merchant_order($payment_info['merchant_order_id']);
                        if ($merchant_order_info['status'] >= 400) {
                            self::log('ERROR-validateMercadoPago['.$mp_op_id.']->get_merchant_order:
                            '.print_r($merchant_order_info, true));
                            return false;
                        }
                    }
                } catch (Exception $e) {
                    self::log('ERROR-validateMercadoPago['.$mp_op_id.']->get_merchant_order:
                                '.$e->getFile()."[".$e->getLine()."] -> ".$e->getMessage());
                    return false;
                }
                self::log('validateMercadoPago['.$mp_op_id.']->get_merchant_order:
                    '.print_r($merchant_order_info, true));
            }
        } else {
            try {
                $merchant_order_info = $this->api->get_merchant_order($mp_op_id);
                if ($merchant_order_info['status'] >= 400) {
                    self::log('ERROR-validateMercadoPago['.$mp_op_id.']->get_merchant_order:
                    '.print_r($merchant_order_info, true));
                    return false;
                }
            } catch (Exception $e) {
                self::log('ERROR-validateMercadoPago['.$mp_op_id.']->get_merchant_order:
                        '.$e->getFile()."[".$e->getLine()."] -> ".$e->getMessage());
                return false;
            }
        }
        if (isset($merchant_order_info['response']) && isset($merchant_order_info['response']['total_amount'])) {
            $merchant_order_info = $merchant_order_info['response'];
            if (isset($merchant_order_info['shipments'])) {
                if (is_array($merchant_order_info['shipments']) && count($merchant_order_info['shipments']) > 0) {
                    foreach ($merchant_order_info['shipments'] as $shipping) {
                        $shipping_info = $shipping;
                        $ret['shipment_ids'][] = $shipping['id'];
                    }
                }
            }
            $payment_pending = false;
            $payment_refunded = false;
            foreach ($merchant_order_info['payments'] as &$payment) {
                $pstatus = $payment['status'];
                if (in_array($pstatus, array('approved', 'refunded', 'authorized', 'pending', 'in_process'))) {
                    try {
                        $payment_info = $this->api->get_payment_info($payment['id']);
                        if ($payment_info['status'] >= 400) {
                            self::log('ERROR-validateMercadoPago['.$payment['id'].']->get_payment_info:
                            '.print_r($payment_info, true));
                            $payment_info = $payment;
                        } elseif (isset($payment_info['response']) && isset($payment_info['response']['collection'])) {
                            $payment_info = $payment_info['response']['collection'];
                            self::log('validateMercadoPago['.$mp_op_id.']->get_payment_info:
                                    '.print_r($payment_info, true));
                            $payment = $payment_info;
                        }
                    } catch (Exception $e) {
                        self::log('ERROR-validateMercadoPago['.$payment['id'].']->get_payment_info:
                                    '.$e->getFile()."[".$e->getLine()."] -> ".$e->getMessage());
                        $payment_info = $payment;
                    }
                }
                $pstatus = $payment['status'];
                if (in_array($pstatus, array('approved', 'refunded', 'authorized', 'pending', 'in_process'))) {
                    $paid_amount += $payment['transaction_amount'] + $payment['shipping_cost'];
                    $commision_amount += $payment['total_paid_amount'] - $payment['net_received_amount'];
                }
                if ($payment['status'] == 'pending' || $payment['status'] == 'in_process') {
                    $payment_pending = true;
                }
                if ($payment['status'] == 'refunded') {
                    $payment_refunded = true;
                }
            }
            if ($shipping_info) {
                if ($shipping_info['shipping_mode'] == 'me2') {
                    $merchant_order_info['shipping_cost'] = $shipping_info['shipping_option']['cost'];
                }
            }
            $scost = isset($merchant_order_info['shipping_cost'])?$merchant_order_info['shipping_cost']:0;
            $diff = abs($paid_amount - ($merchant_order_info['total_amount'] + $scost));
            self::log("paid_amount: $diff ===>>> $paid_amount <> {$merchant_order_info['total_amount']} + $scost");
            if (!$payment_refunded && !$payment_pending && $diff < 1.5) {
                $status_act = Configuration::get($this->config['os_authorization']);
                self::log('OK --> paid_amount');
            } elseif (!$payment_refunded && !$payment_pending && $paid_amount < 0.01) {
                self::log('ERROR --> paid_amount');
                $status_act = $this->config['os_refused'];
            } elseif (!$payment_refunded) {
                self::log('ERROR --> paid pending --> '.$payment_pending.' <-> '.$paid_amount);
                $status_act = $this->os_pending;
            } else {
                $status_act = Configuration::get('PS_OS_REFUND');
            }
        }
        self::log('validateMercadoPago['.$mp_op_id.']->get_merchant_order:
            '.print_r($merchant_order_info, true));
        if (!$status_act && !$payment_info) {
            //if (isset($merchant_order_info['external_reference'])) {
            //    $payment_info = array('id' => 0, 'currency_id' => $this->settings['CURRENCY']);
            //    $status_act = Configuration::get(self::MP_PREFIX.'OS_PENDING');
            //} else {
                return false;
            //}
        } elseif (!$status_act) {
            if (!isset($payment_info['status']) || !isset($payment_info['order_id'])) {
                $ret['errors'][] = 'Error: '.print_r($payment_info, true);
            } else {
                switch ($payment_info['status']) {
                    case 'approved':
                    case 'authorized':
                        $status_act = $this->config['os_authorization'];
                        break;
                    case 'refunded':
                        $status_act = Configuration::get('PS_OS_REFUND');
                        break;
                    case 'cancelled':
                    case 'rejected':
                        $status_act = $this->config['os_refused'];
                        break;
                    default:
                        $status_act = $this->os_pending;
                        break;
                }
            }
        }
        $fee = ((float)$this->config['fee']) / 100.0;
        $famount = (float)$this->config['fee_amount'];
        if (isset($merchant_order_info['external_reference'])) {
            $ret['shipping'] = isset($merchant_order_info['shipping_cost'])?$merchant_order_info['shipping_cost']:0;
            //$ret['fee'] = (float)($merchant_order_info['total_amount'] -
            //(float)$this->config['fee_amount']) * $fee + (float)$this->config['fee_amount'];
            //$ret['price'] = (float)$merchant_order_info['total_amount'] - $ret['fee'];
            //$ret['price_with_fee'] = (float)$merchant_order_info['total_amount'];
            $ret['fee'] = (float)($merchant_order_info['total_amount'] + $ret['shipping'] - $famount) * $fee + $famount;
            $ret['price'] = (float)$merchant_order_info['total_amount'] + $ret['shipping'] - $ret['fee'];
            $ret['price_with_fee'] = (float)$merchant_order_info['total_amount'] + $ret['shipping'];
            $ret['mp_op_id'] = $payment_info['id'];
            $ret['mp_order_id'] = $merchant_order_info['id'];
            $ret['order_id'] = (int)$merchant_order_info['external_reference'];
            $scost = isset($merchant_order_info['shipping_cost'])?$merchant_order_info['shipping_cost']:0;
            $ret['paid_amount_expected'] = $merchant_order_info['total_amount'] + $scost;
        } else {
            //$total_paid_amount = (float)$payment_info['total_paid_amount'] -
                //(isset($payment_info['shipping_cost'])?(float)$payment_info['shipping_cost']:0);
            $total_paid_amount = (float)$payment_info['total_paid_amount'];
            $ret['fee'] = ($total_paid_amount - (float)$famount) * $fee + (float)$famount;
            $ret['price_with_fee'] = (float)$total_paid_amount;
            $ret['price'] = (float)$total_paid_amount - $ret['fee'];
            $ret['shipping'] = isset($payment_info['shipping_cost'])?$payment_info['shipping_cost']:0;
            $ret['mp_op_id'] = $payment_info['id'];
            $ret['order_id'] = (int)$payment_info['external_reference'];
            $ret['paid_amount_expected'] = 0;
        }
        if (isset($payment_info['payer']) && isset($payment_info['payer']['identification'])) {
            $ret['identification'] = $payment_info['payer']['identification']['type'];
            $ret['identification'] .= ' '.$payment_info['payer']['identification']['number'];
        } else {
            $ret['identification'] = $this->l('Not available');
        }
        if (isset($payment_info['payer']) && isset($payment_info['payer']['first_name'])) {
            $ret['client_name'] = trim($payment_info['payer']['first_name'].' '.$payment_info['payer']['last_name']);
        } else {
            $ret['client_name'] = $this->l('Not available');
        }
        $ret['transaction_id'] = $payment_info['id'];
        $ret['last_four_digits'] = false;
        $ret['cardholder_name'] = false;
        $ret['card_brand'] = false;
        if (isset($payment_info['payment_method_id']) && !empty($payment_info['payment_method_id'])) {
            $ret['card_brand'] = Tools::ucfirst($payment_info['payment_method_id']);
        }
        if (isset($payment_info['card'])) {
            if (isset($payment_info['card']['last_four_digits']) &&
                !empty($payment_info['card']['last_four_digits'])
            ) {
                $ret['last_four_digits'] = '**** **** **** '.$payment_info['card']['last_four_digits'];
            }
            if (isset($payment_info['card']['cardholder']) &&
                isset($payment_info['card']['cardholder']['name']) &&
                !empty($payment_info['card']['cardholder']['name'])
            ) {
                $ret['cardholder_name'] = Tools::strtoupper($payment_info['card']['cardholder']['name']);
            }
        }
        if (isset($payment_info['last_four_digits']) &&
            !empty($payment_info['last_four_digits'])
        ) {
            $ret['last_four_digits'] = '**** **** **** '.$payment_info['last_four_digits'];
        }
        if (isset($payment_info['cardholder']) &&
            isset($payment_info['cardholder']['name']) &&
            !empty($payment_info['cardholder']['name'])
        ) {
            $ret['cardholder_name'] = Tools::strtoupper($payment_info['cardholder']['name']);
        }
        $ret['total'] = $ret['price_with_fee'];
        $ret['status'] = $status_act;
        $ret['paid_amount'] = $paid_amount;
        $ret['commision_amount'] = $commision_amount;
        $ret['is_mp_envios'] = $shipping_info?true:false;
        $ret['sandbox'] = $is_sandbox;
        $ret['currency_id'] = $payment_info['currency_id'];
        $ret['message1'] = Tools::jsonEncode($merchant_order_info).'\n';
        $ret['message2'] = Tools::jsonEncode($payment_info).'\n';
        if (empty($ret['currency_id'])
            || ($ret['paid_amount'] > 0
            && $ret['paid_amount_expected'] > 0
            && abs($ret['paid_amount_expected'] - $ret['paid_amount']) > 0.1)) {
            self::log('validateMercadoPago['.$mp_op_id.']->return
                        ERROR - CURRENCY ID EMPTY OR PAYMENT EXPECTED INVALID --->> '.print_r($ret, true));
            return false;
        }
        self::log('validateMercadoPago['.$mp_op_id.']->return: '.print_r($ret, true));
        return $ret;
    }
    public function hookDisplayPDFInvoice($params)
    {
        $order_invoice = $params['object'];
        $order = new Order((int)$order_invoice->id_order);
        $valid = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
                        SELECT * FROM `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`
                        WHERE `id_order` = '.(int)$order->id);

        self::log('hookDisplayPDFInvoice-valid: '.print_r($valid, true));
        if (isset($valid[0])) {
            $valid = $valid[0];
        }
        if (!$valid || !isset($valid['mp_op_id'])) {
            return '';
        }
        $result = $this->validateMercadoPago($valid['topic'], $valid['mp_op_id'], $valid['is_sandbox']);
        if ($result && isset($result['status'])) {
            $currency = new Currency((int)$order->id_currency);
            $total_price = 0;
            //if ($result['is_mp_envios']) {
            //    $total_price = $order->total_paid_tax_incl - $order->total_shipping_tax_incl;
            //} else {
            $total_price = $order->total_paid_tax_incl;
            //}
            $diff = abs($total_price - $this->getRate(
                Tools::strtoupper($result['currency_id']),
                Tools::strtoupper($currency->iso_code)
            ) * $result['price_with_fee']);
            $same_cur = Tools::strtoupper($result['currency_id']) == Tools::strtoupper($currency->iso_code);
            if ($same_cur && $diff > $total_price * 0.01 || !$same_cur && $diff > $total_price * 0.03) {
                return $this->instance_module->lang('Commission charge a customer for using MercadoPago:').'
                       '.Tools::displayPrice($diff, $currency);
            }
        }
        return '';
    }
    public function hookDisplayAdminOrder($params, $file_template)
    {
        $order_id = (int)$params['id_order'];
        $valid = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
                        SELECT * FROM `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`
                        WHERE `id_order` = '.(int)$order_id);

        self::log('hookDisplayAdminOrder-valid: '.print_r($valid, true));

        if (isset($valid[0])) {
            $valid = $valid[0];
        }
        if (!$valid || !isset($valid['mp_op_id'])) {
            return false;
        }
        $has_refund = Db::getInstance()->ExecuteS('SELECT *
                        FROM `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'_refunds`
                        WHERE `id_order` = '.(int)$order_id);

        self::log('hookDisplayAdminOrder-has_refund: '.print_r($has_refund, true));

        if (isset($has_refund[0])) {
            $has_refund = $has_refund[0];
        }
        $validation = $this->validateMercadoPago($valid['topic'], $valid['mp_op_id'], $valid['is_sandbox']);
        if ($validation && isset($validation['status'])) {
            self::log('hookDisplayAdminOrder-validation: '.print_r($validation, true));
            $order = new Order($params['id_order']);
            $cancel_status = array(
                (int)Configuration::get('PS_OS_CANCELED'),
                (int)Configuration::get('PS_OS_DELIVERED'),
                //(int)Configuration::get('PS_OS_REFUND'),
                (int)Configuration::get('PS_OS_OUTOFSTOCK'),
                (int)Configuration::get('PS_OS_OUTOFSTOCK_PAID'),
                (int)Configuration::get('PS_OS_OUTOFSTOCK_UNPAID')
            );
            $status_act = $order->getCurrentState();
            if ($status_act != $validation['status']
                && !in_array($status_act, $cancel_status)
                && $valid['status'] == $status_act) {
                self::$ignore_update_status = true;
                $order->setCurrentState($validation['status']);
                self::$ignore_update_status = false;
                Db::getInstance()->Execute('UPDATE `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`
                    SET
                        `next_retry` = '.(int)(time() + 6 * 60 * 60).',
                        `status` = '.(int)$order->getCurrentState().'
                    WHERE id = '.(int)$valid['id']);
            }
        }
        $order_state = new OrderState($valid['status']);
        $url_labels = array();
        if (isset($validation['shipment_ids']) && count($validation['shipment_ids']) > 0) {
            $link_tpl   = $this->instance_module->display($file_template, 'views/templates/admin/link.tpl');
            foreach ($validation['shipment_ids'] as $shipping_id) {
                $result = false;
                $url = $this->readPDFMercadoEnvios($shipping_id, $order_id, $result);
                if ($result) {
                    $url_labels[] = sprintf($link_tpl, $url, $this->l('Download'));
                } else {
                    $url_labels[] = $url;
                }
            }
        }
        return array(
            'order_id' => $order_id,
            'mp_data' => $valid,
            'mercadoenvios_available' => $this->mercadoenvios_available,
            'mp_validation' => $validation,
            'is_sandbox' => $valid && $valid['is_sandbox']?$this->l('Yes'):$this->l('No'),
            'mp_label_shipping' => $url_labels,
            'has_refund' => $has_refund,
            'mp_last_sync' => date('Y-m-d H:i:s', $valid['next_retry'] - 6 * 60 * 60),
            'mp_status' => $order_state->name[$this->context->language->id],
            'backwardcompatible' => _PS_VERSION_ < '1.6'
        );
    }
    public function hookOrderConfirmation($order)
    {
        $status_act = $order->getCurrentState();
        //print_r($status_act);
        //echo '-'.$this->os_pending;
        switch ($status_act) {
            case $this->config['os_authorization']:
            case Configuration::get('PS_OS_PREPARATION'):
            case Configuration::get('PS_OS_SHIPPING'):
                $result = array('status' => 'ok', 'id_order' => $order->id);
                break;
            case $this->os_pending:
                $result = array('status' => 'pending', 'id_order' => $order->id);
                break;
            default:
                $result = array('status' => 'failed');
                break;
        }
        $result['shop_name'] = '';
        //print_r($result);
        return $result;
    }
    public function cronjob($smarty, $file_template)
    {
        if (is_null($this->api)) {
            return;
        }
        $valid = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
                        SELECT * FROM `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`
                        WHERE `next_retry` < '.(int)time().' AND

                        (`status` = '.(int)$this->os_pending.'
                            OR
                         `status` = '.(int)Configuration::get('PS_OS_PREPARATION').'
                            OR
                         `status` = '.(int)Configuration::get('PS_OS_SHIPPING').') LIMIT 3');
        $cancel_status = array(
            (int)Configuration::get('PS_OS_CANCELED'),
            (int)Configuration::get('PS_OS_DELIVERED'),
            //(int)Configuration::get('PS_OS_REFUND'),
            (int)Configuration::get('PS_OS_OUTOFSTOCK'),
            (int)Configuration::get('PS_OS_OUTOFSTOCK_PAID'),
            (int)Configuration::get('PS_OS_OUTOFSTOCK_UNPAID')
        );
        foreach ($valid as &$pago) {
            $order = new Order($pago['id_order']);
            if (Validate::isLoadedObject($order)) {
                $status_act = $order->getCurrentState();
                if (!in_array($status_act, $cancel_status) && $status_act == $pago['status']) {
                    $result = $this->validateMercadoPago($pago['topic'], $pago['mp_op_id'], $pago['is_sandbox']);
                    if (isset($result['status'])) {
                        if ($result['status'] != $order->getCurrentState()) {
                            self::$ignore_update_status = true;
                            $order->setCurrentState($result['status']);
                            self::$ignore_update_status = false;
                            $status_act = $order->getCurrentState();
                        }
                    }
                    Db::getInstance()->Execute('UPDATE `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`
                        SET
                            `next_retry` = '.(int)(time() + 6 * 60 * 60).',
                            `status` = '.(int)$status_act.'
                        WHERE id = '.(int)$pago['id']);
                } else {
                    Db::getInstance()->Execute('UPDATE `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`
                        SET
                            `next_retry` = '.(int)(time() + 6 * 60 * 60).',
                            `status` = '.(int)Configuration::get('PS_OS_DELIVERED').'
                        WHERE id = '.(int)$pago['id']);
                }
            }
        }
        $ps_version = 1.6;
        if (version_compare(_PS_VERSION_, '1.6') < 0) {
            $ps_version = 1.5;
        }
        if (version_compare(_PS_VERSION_, '1.7.0.0') >= 0) {
            $ps_version = 1.7;
        }
        $smarty->assign('ps_version', $ps_version);
        if (isset($this->config['publickey']) && $this->config['publickey'] != "") {
            $smarty->assign('publickey', $this->config['publickey']);
        } else {
            $smarty->assign('publickey', false);
        }
        return $this->instance_module->display($file_template, 'views/templates/hook/cronjob.tpl');
    }
    public function hookUpdateOrderStatus($params)
    {
        if (!$this->api || self::$ignore_update_status) {
            return '';
        }

        if (in_array((int)$params['newOrderStatus']->id, $this->config['status_refound'])) {
            $id_order = $params['id_order'];
            $has_mp_order = Db::getInstance()->ExecuteS('SELECT *
                                                FROM `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`
                                                WHERE `id_order` = '.(int)$id_order);
            if ($has_mp_order && isset($has_mp_order[0])) {
                $has_mp_order = $has_mp_order[0];
                $has_refund = Db::getInstance()->ExecuteS('SELECT *
                                                FROM `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'_refunds`
                                                WHERE `id_order` = '.(int)$id_order);
                if (!$has_refund) {
                    $payment = $this->validateMercadoPago(
                        $has_mp_order['topic'],
                        $has_mp_order['mp_op_id'],
                        $has_mp_order['is_sandbox']
                    );
                    switch ($payment['status']) {
                        case (int)$this->config['os_authorization']:
                        case (int)Configuration::get('PS_OS_PREPARATION'):
                        case (int)Configuration::get('PS_OS_SHIPPING'):
                        case (int)Configuration::get('PS_OS_DELIVERED'):
                            try {
                                $result = $this->api->refund_payment($payment['mp_op_id']);
                                if ($result['status'] >= 400) {
                                    self::log('ERROR-refund_payment: '.print_r($result, true));
                                    return '';
                                }
                                Db::getInstance()->Execute('INSERT IGNORE INTO 
                                        `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'_refunds`
                                    (id_order, mp_op_id, date_create, response) VALUES
                                    (   '.(int)$id_order.',
                                        \''.pSQL($has_mp_order['mp_op_id']).'\',
                                        NOW(),
                                        \''.pSQL(Tools::jsonEncode($result)).'\'
                                    )');
                                self::log('refund_payment: '.print_r($has_mp_order, true).' -> 
                                    '.print_r($result, true));
                            } catch (Exception $e) {
                                self::log('Refound error: '.print_r($has_mp_order, true).' -> 
                                    '.$e->getFile()."[".$e->getLine()."] -> ".$e->getMessage());
                            }
                            break;
                        default:
                            return '';
                    }
                }
            }
        }
        return '';
    }
    public function ipn()
    {
        $rand_mutex = rand();
        self::log('validation['.$rand_mutex.']: '.print_r($_GET, true).print_r($_POST, true));
        $result = $this->validateMercadoPago(Tools::getValue('topic'), Tools::getValue('id'));

        if (!Tools::getValue('id')) {
            die('ID Desconocido');
        }

        $mutex = new MpMutex('mpk_validation');

        self::log('validation-['.$rand_mutex.']: init lock mp_validation - 
            '.Tools::getValue('topic').Tools::getValue('id'));

        while (!$mutex->lock()) {
            sleep(.5);
        }

        self::log('validation-['.$rand_mutex.']: lock '.Tools::getValue('topic').Tools::getValue('id'));

        if ($result && isset($result['status']) && isset($result['order_id'])) {
            $id_cart = (int)$result['order_id'];
            $cart = new Cart($id_cart);
            if (!Validate::isLoadedObject($cart)) {
                $mutex->releaseLock();
                exit;
            }

            self::log('validation-['.$rand_mutex.']: cart-'.$id_cart.' 
                '.Tools::getValue('topic').Tools::getValue('id'));
            $status_act = $result['status'];
            $id_order = Order::getOrderByCartId($id_cart);

            $customer = new Customer((int)$cart->id_customer);
            $currency = new Currency((int)$cart->id_currency);

            $context = $this->context;
            $context->cart = $cart;
            $context->cookie->id_currency = (int)$cart->id_currency;
            $context->customer = $customer;
            $context->currency = $currency;

            $order = null;

            if ($id_order > 0) {
                $order = new Order($id_order);
                $status_mp = (int)Db::getInstance()->getValue('SELECT `status` FROM 
                        `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`
                        WHERE `id_order` = '.(int)$id_order);
                if ($status_mp < 1) {
                    Db::getInstance()->Execute('INSERT INTO `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'` (id_order, id_shop,
                            `topic`, mp_op_id, is_sandbox, status, next_retry)
                                VALUES
                            ('.(int)$order->id.', '.(int)$order->id_shop.',
                             \''.pSQL(Tools::getValue('topic')).'\',
                             \''.pSQL(Tools::getValue('id')).'\',
                             \''.(int)$result['sandbox'].'\',
                             '.(int)$order->getCurrentState().',
                             '.(int)(time() + 6 * 60 * 60).')');
                    $status_mp = (int)Db::getInstance()->getValue('SELECT `status` FROM 
                            `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`
                            WHERE `id_order` = '.(int)$id_order);
                }
                $status_ps = (int)$order->getCurrentState();
                $cancel_status = array(
                    (int)Configuration::get('PS_OS_CANCELED'),
                    (int)Configuration::get('PS_OS_PREPARATION'),
                    (int)Configuration::get('PS_OS_DELIVERED'),
                    //(int)Configuration::get('PS_OS_REFUND'),
                    (int)Configuration::get('PS_OS_OUTOFSTOCK'),
                    (int)Configuration::get('PS_OS_OUTOFSTOCK_PAID'),
                    (int)Configuration::get('PS_OS_OUTOFSTOCK_UNPAID')
                );
                if ($status_ps > 0 && (in_array($status_ps, $cancel_status) || $status_mp != $status_ps)) {
                    $status_act = $status_ps;
                } else {
                    if ($status_act != $status_ps) {
                        self::$ignore_update_status = true;
                        $order->setCurrentState($status_act);
                        self::$ignore_update_status = false;
                    }
                    Db::getInstance()->Execute('UPDATE `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`
                        SET
                            `next_retry` = '.(int)(time() + 6 * 60 * 60).',
                            `status` = '.(int)$status_act.'
                        WHERE id_order = '.(int)$id_order);
                }
                self::log('validation-['.$rand_mutex.']: validateOrder-'.$id_cart.'-'.$id_order.'-end 
                    '.Tools::getValue('topic').Tools::getValue('id'));
            } else {
                $msg = '';
                $fee = 100.0 / (100.0 - (float)$this->config['fee']);
                $original_total_price = 0;
                $rate_dst = $this->getRate(
                    Tools::strtoupper($currency->iso_code),
                    Tools::strtoupper($result['currency_id'])
                );
                //if (isset($this->list_shippings['ps_mp'][$cart->id_carrier])) {
                //    $original_total_cart = $cart->getOrderTotal(true, Cart::BOTH_WITHOUT_SHIPPING);
                //    $original_total_price = Tools::ps_round($original_total_cart, 2);
                //} else {
                $original_total_price = Tools::ps_round($cart->getOrderTotal(true, Cart::BOTH), 2);
                //}
                $total_price = $original_total_price * $rate_dst;
                $total = Tools::ps_round($fee * $total_price + $this->config['fee_amount'], 2);
                $original_total = Tools::ps_round($fee * $original_total_price + $this->config['fee_amount'], 2);
                $diff = abs($total - $result['price_with_fee']);
                $same_cur = Tools::strtoupper($result['currency_id']) == Tools::strtoupper($currency->iso_code);
                self::log('validation-['.$rand_mutex.']: total-'.$id_cart.' '.$total_price);

                if ($same_cur && $diff > $total * 0.01 || !$same_cur && $diff > $total * 0.03) {
                    $status_act = (int)Configuration::get('PS_OS_ERROR');
                    $msg .= $this->l('Maybe Hacking Price (Price Diff:')." {$diff} {$result['currency_id']}\n\n";
                }
                if (!$same_cur) {
                    $msg .= $this->l('Prestashop order price (currency order): ');
                    $msg .= " {$original_total_price} {$currency->iso_code})\n\n";
                    $msg .= $this->l('Prestashop order price with fee (currency order): ');
                    $msg .= " {$original_total} {$currency->iso_code})\n\n";
                }
                $payed = $result['price_with_fee']; // + $result['shipping'];
                $msg .= $this->l('Prestashop order price: ')." {$total_price} {$result['currency_id']}\n\n";
                $msg .= $this->l('Prestashop order price with fee: ')." {$total} {$result['currency_id']}\n\n";
                $msg .= $this->l('Products price: ')." {$result['price']} {$result['currency_id']}\n";
                $msg .= $this->l('Commission price: ')." {$result['fee']} {$result['currency_id']}\n";
                if ($this->mercadoenvios_available) {
                    $msg .= $this->l('MercadEnvios price: ')." {$result['shipping']} {$result['currency_id']}\n";
                }
                $msg .= $this->l('Payed: ')." {$payed} {$result['currency_id']}\n\n";
                if (!$same_cur) {
                    $msg .= ' '.$this->l('The customer payment through');
                    $msg .= ' '.Tools::strtoupper($result['currency_id']);
                    $msg .= ' '.$this->l(', currency of the order');
                    $msg .= ' '.Tools::strtoupper($currency->iso_code).'. ';
                    $msg .= $this->l('This maybe can generate additional commissions due to currency conversions.');
                }
                self::log('validation-['.$rand_mutex.']: validateOrder-'.$id_cart.'-init
                    '.Tools::getValue('topic').Tools::getValue('id'));
                $name = trim($this->instance_module->displayName);
                self::$ignore_update_status = true;
                $this->instance_module->validateOrder(
                    $id_cart,
                    $status_act,
                    //(float)$result['price'] / (float)$rate_dst,
                    $cart->getOrderTotal(true, Cart::BOTH),
                    !empty($name)?$name:'MercadoPago',
                    $msg,
                    array(),
                    (int)$cart->id_currency,
                    false,
                    $customer->secure_key
                );
                $order = new Order(Order::getOrderByCartId($id_cart));
                $status_ps = (int)$order->getCurrentState();
                if ($status_ps != $status_act) {
                    $order->setCurrentState($status_act);
                }
                $order_payments = $order->getOrderPayments();
                foreach ($order_payments as $order_payment) {
                    $order_payment->transaction_id = $result['transaction_id'];
                    if ($result['card_brand']) {
                        $order_payment->card_number = $result['last_four_digits'];
                        $order_payment->card_brand = $result['card_brand'];
                        $order_payment->card_holder = $result['cardholder_name'];
                    }
                    $order_payment->save();
                }
                self::$ignore_update_status = false;
                self::log('validation-['.$rand_mutex.']: validateOrder-'.$id_cart.'-end 
                    '.Tools::getValue('topic').Tools::getValue('id'));
            }

            if (!$order || !Validate::isLoadedObject($order)) {
                $order = new Order(Order::getOrderByCartId($id_cart));
            }
            if (Validate::isLoadedObject($order)) {
                $status_mp = (int)Db::getInstance()->getValue('SELECT `status` FROM 
                    `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`
                    WHERE `id_order` = '.(int)$order->id);
                if ($status_mp < 1) {
                    Db::getInstance()->Execute('INSERT INTO `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'` (id_order, id_shop,
                        `topic`, mp_op_id, is_sandbox, status, next_retry)
                            VALUES
                        ('.(int)$order->id.', '.(int)$order->id_shop.',
                         \''.pSQL(Tools::getValue('topic')).'\',
                         \''.pSQL(Tools::getValue('id')).'\',
                         \''.(int)$result['sandbox'].'\',
                         '.(int)$order->getCurrentState().',
                         '.(int)(time() + 6 * 60 * 60).')');
                }
            }
        }
        self::log('validation-['.$rand_mutex.']: releaseLock '.Tools::getValue('topic').Tools::getValue('id'));
        $mutex->releaseLock();
    }
    public function returnMP()
    {
        $rand_mutex = rand();
        self::log('return['.$rand_mutex.']: '.print_r($_GET, true).print_r($_POST, true));

        $collection_id = Tools::getValue('collection_id');
        if (!empty($collection_id)) {
            list($collection_id) = preg_split('/,/', $collection_id);
        }
        $collection_status = Tools::getValue('collection_status');
        $merchant_order_id = Tools::getValue('merchant_order_id');
        if (!empty($merchant_order_id) || empty($collection_id) || $collection_id == 'null') {
            $topic = 'marchent';
            $op_id = $merchant_order_id;
        } else {
            $topic = 'payment';
            $op_id = $collection_id;
        }
        $result = $this->validateMercadoPago($topic, $op_id);

        self::log('return-['.$rand_mutex.']: init lock mp_validation - 
            '.Tools::getValue('external_reference').' result: '.print_r($result, true));
        $mutex = new MpMutex('mpk_validation');
        while (!$mutex->lock()) {
            sleep(.5);
        }
        self::log('return-['.$rand_mutex.']: lock '.Tools::getValue('external_reference'));

        if ($result && $collection_status && !empty($collection_status)) {
            if ($collection_status == 'null' || is_null($collection_status)) {
                self::log('return-['.$rand_mutex.']: releaseLock1 '.Tools::getValue('external_reference'));
                $mutex->releaseLock();
                if (_PS_VERSION_ >= '1.5') {
                    Tools::redirect('index.php?controller=cart');
                } else {
                    Tools::redirect('cart.php');
                }
                return;
            }
            $id_cart = (int)Tools::getValue('external_reference');

            $cart = new Cart($id_cart);
            if (!Validate::isLoadedObject($cart)) {
                self::log('return-['.$rand_mutex.']: releaseLock2 '.Tools::getValue('external_reference'));
                $mutex->releaseLock();
                Tools::redirect('cart.php');
                return;
            }

            $id_order = (int)Order::getOrderByCartId($id_cart);

            if ($id_order <= 0) {
                if ($result['status'] && $result['order_id']) {
                    $context = $this->context;
                    if ($id_cart != (int)$result['order_id']
                        || (int)$cart->id_customer != (int)$context->customer->id) {
                        self::log('return-['.$rand_mutex.']: releaseLock3 '.Tools::getValue('external_reference'));
                        $mutex->releaseLock();
                        if (_PS_VERSION_ >= '1.5') {
                            Tools::redirect('index.php?controller=cart');
                        } else {
                            Tools::redirect('cart.php');
                        }
                        return;
                    }

                    $cart = new Cart($id_cart);
                    $customer = new Customer((int)$cart->id_customer);

                    $status_act = $result['status'];
                    $currency = new Currency((int)$cart->id_currency);
                    $context->cart = $cart;
                    $context->cookie->id_currency = (int)$cart->id_currency;
                    $context->customer = $customer;
                    $context->currency = $currency;
                    $msg = '';
                    $fee = 100.0 / (100.0 - (float)$this->config['fee']);
                    $original_total_price = 0;
                    $rate_dst = $this->getRate(
                        Tools::strtoupper($currency->iso_code),
                        Tools::strtoupper($result['currency_id'])
                    );
                    /* if (isset($this->list_shippings['ps_mp'][$cart->id_carrier])) {
                        $original_total_price = Tools::ps_round(
                            $cart->getOrderTotal(true, Cart::BOTH_WITHOUT_SHIPPING),
                            2
                        );
                    } else { */
                        $original_total_price = Tools::ps_round($cart->getOrderTotal(true, Cart::BOTH), 2);
                    //}
                    $total_price = $original_total_price * $rate_dst;
                    $total = round($fee * $total_price + $this->config['fee_amount'], 2);
                    $original_total = Tools::ps_round($fee * $original_total_price + $this->config['fee_amount'], 2);
                    $diff = abs($total - $result['price_with_fee']);
                    $same_cur = Tools::strtoupper($result['currency_id']) == Tools::strtoupper($currency->iso_code);
                    if ($same_cur && $diff > $total * 0.01 || !$same_cur && $diff > $total * 0.03) {
                        $status_act = (int)Configuration::get('PS_OS_ERROR');
                        $msg .= $this->l('Maybe Hacking Price (Price Diff:')." {$diff} {$result['currency_id']}\n\n";
                    }
                    if (!$same_cur) {
                        $msg .= $this->l('Prestashop order price (currency order): ');
                        $msg .= " {$original_total_price} {$currency->iso_code})\n\n";
                        $msg .= $this->l('Prestashop order price with fee (currency order): ');
                        $msg .= " {$original_total} {$currency->iso_code})\n\n";
                    }
                    $payed = $result['price_with_fee'];// + $result['shipping'];
                    $msg .= $this->l('Prestashop order price: ')." {$total_price} {$result['currency_id']}\n\n";
                    $msg .= $this->l('Prestashop order price with fee: ')." {$total} {$result['currency_id']}\n\n";
                    $msg .= $this->l('Products price: ')." {$result['price']} {$result['currency_id']}\n";
                    $msg .= $this->l('Commission price: ')." {$result['fee']} {$result['currency_id']}\n";
                    if ($this->mercadoenvios_available) {
                        $msg .= $this->l('MercadEnvios price: ')." {$result['shipping']} {$result['currency_id']}\n";
                    }
                    $msg .= $this->l('Payed: ')." {$payed} {$result['currency_id']}\n\n";
                    if (!$same_cur) {
                        $msg .= ' '.$this->l('The customer payment through');
                        $msg .= ' '.Tools::strtoupper($result['currency_id']);
                        $msg .= ' '.$this->l(', currency of the order');
                        $msg .= ' '.Tools::strtoupper($currency->iso_code).'. ';
                        $msg .= $this->l('This maybe can generate additional commissions due to currency conversions.');
                    }
                    self::log('return-['.$rand_mutex.']: validateOrder-'.$id_cart.'
                        '.Tools::getValue('external_reference').' msg: '.$msg);
                    $name = trim($this->instance_module->displayName);
                    self::$ignore_update_status = true;
                    $this->instance_module->validateOrder(
                        $id_cart,
                        $status_act,
                        //(float)$result['price'] / (float)$rate_dst,
                        $cart->getOrderTotal(true, Cart::BOTH),
                        !empty($name)?$name:'MercadoPago',
                        $msg,
                        array(),
                        (int)$cart->id_currency,
                        false,
                        $customer->secure_key
                    );
                    self::log(
                        'return-['.$rand_mutex.']: validateOrder-'.$id_cart.'-end
                        '.Tools::getValue('external_reference')
                    );
                    $order = new Order(Order::getOrderByCartId($id_cart));
                    $id_order = $order->id;
                    $order_payments = $order->getOrderPayments();
                    foreach ($order_payments as $order_payment) {
                        $order_payment->transaction_id = $result['transaction_id'];
                        if ($result['card_brand']) {
                            $order_payment->card_number = $result['last_four_digits'];
                            $order_payment->card_brand = $result['card_brand'];
                            $order_payment->card_holder = $result['cardholder_name'];
                        }
                        $order_payment->save();
                    }
                    self::$ignore_update_status = false;

                    if (Validate::isLoadedObject($order)) {
                        Db::getInstance()->Execute('INSERT INTO `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'` (id_order,
                                    id_shop, `topic`, mp_op_id, is_sandbox, status, next_retry)
                                        VALUES
                                    ('.(int)$order->id.',
                                     '.(int)$order->id_shop.',
                                     \''.pSQL($topic).'\',
                                     \''.pSQL($op_id).'\',
                                     \''.(int)$result['sandbox'].'\',
                                     '.(int)$order->getCurrentState().',
                                     '.(int)(time() + 6 * 60 * 60).')');
                    }
                }
            } else {
                $status_act = $result['status'];
                $order = new Order($id_order);
                $status_mp = (int)Db::getInstance()->getValue('SELECT `status` FROM 
                        `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`
                        WHERE `id_order` = '.(int)$id_order);
                $status_ps = (int)$order->getCurrentState();
                $cancel_status = array(
                    (int)Configuration::get('PS_OS_CANCELED'),
                    (int)Configuration::get('PS_OS_PREPARATION'),
                    (int)Configuration::get('PS_OS_DELIVERED'),
                    //(int)Configuration::get('PS_OS_REFUND'),
                    (int)Configuration::get('PS_OS_OUTOFSTOCK'),
                    (int)Configuration::get('PS_OS_OUTOFSTOCK_PAID'),
                    (int)Configuration::get('PS_OS_OUTOFSTOCK_UNPAID')
                );
                if ($status_ps > 0 && (in_array($status_ps, $cancel_status) || $status_mp != $status_ps)) {
                    $status_act = $status_ps;
                } else {
                    if ($status_act != $status_ps) {
                        self::$ignore_update_status = true;
                        $order->setCurrentState($status_act);
                        self::$ignore_update_status = false;
                    }
                    Db::getInstance()->Execute('UPDATE `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`
                        SET
                            `next_retry` = '.(int)(time() + 6 * 60 * 60).',
                            `status` = '.(int)$status_act.'
                        WHERE id_order = '.(int)$id_order);
                }
                self::log('returnMP-['.$rand_mutex.']: Old status '.$status_ps.' - Actual: '.$status_act);
                self::log('returnMP-['.$rand_mutex.']: returnMP-'.$id_cart.'-'.$id_order.'-end 
                    '.Tools::getValue('topic').Tools::getValue('id'));
            }
            if ($id_order > 0) {
                self::log('return-['.$rand_mutex.']: releaseLock4 '.Tools::getValue('external_reference'));
                $mutex->releaseLock();
                $order = new Order($id_order);
                $customer = new Customer((int)$cart->id_customer);
                if (_PS_VERSION_ >= '1.5') {
                    Tools::redirect(
                        'index.php?controller=order-confirmation&id_cart='.$cart->id
                        .'&id_module='.$this->instance_module->id.'&id_order='.$order->id
                        .'&key='.$customer->secure_key
                    );
                } else {
                    Tools::redirect(
                        'order-confirmation.php?id_cart='.$cart->id.'&id_module='
                        .$this->instance_module->id.'&id_order='.$order->id
                        .'&key='.$customer->secure_key
                    );
                }
                return;
            }
        }

        self::log('return-['.$rand_mutex.']: releaseLock5 '.Tools::getValue('external_reference'));
        $mutex->releaseLock();
        if (_PS_VERSION_ >= '1.5') {
            Tools::redirect('index.php?controller=cart');
        } else {
            Tools::redirect('cart.php');
        }
    }
    private function urlExists($file)
    {
        $file_headers = @get_headers($file);
        if (is_array($file_headers) && preg_match("/^HTTP.+\s(\d\d\d)\s/", $file_headers[0], $m) && isset($m[1])) {
            return (int)$m[1] >= 200 && (int)$m[1] < 300;
        } else {
            return false;
        }
    }
    public function paymentButton($params)
    {
        if (is_null($this->api) || is_null($this->api_me)) {
            return false;
        }
        $link = new Link();
        $currency = new Currency((int)$params['cart']->id_currency);
        //$lang = new Language((int)$params['cart']->id_lang);
        $customer = new Customer((int)$params['cart']->id_customer);
        $address = new Address((int)$params['cart']->id_address_invoice);
        //$country = new Country((int)$address->id_country, (int)$params['cart']->id_lang);
        //$products = $params['cart']->getProducts();
        $fee = 100.0 / (100.0 - (float)$this->config['fee']);

        //$url = (_PS_VERSION_ < '1.5') ? 'order-confirmation.php' : 'index.php?controller=order-confirmation';
        $total_price = 0;
        $shipping_price = 0;
        $full_total_price = $params['cart']->getOrderTotal(true, Cart::BOTH);
        $is_mp_envios = false;
        if ($this->mercadoenvios_available &&
            $this->config['shipping_active'] &&
            isset($this->list_shippings['ps_mp'][$params['cart']->id_carrier])
        ) {
            $total_price = $params['cart']->getOrderTotal(true, Cart::BOTH_WITHOUT_SHIPPING);
            $shipping_price = $full_total_price - $total_price;
            $is_mp_envios = true;
        } else {
            $total_price = $full_total_price;
        }
        $logo = false;
        if (isset($this->config['logo_mercadopago_checkout']) && $this->config['logo_mercadopago_checkout']) {
            if (Tools::strtolower(Tools::substr($this->config['logo_mercadopago_checkout'], 0, 4)) != 'http') {
                $logo = $this->site_url.'modules/'.$this->module_name.$this->config['logo_mercadopago_checkout'];
            } else {
                $logo = $this->config['logo_mercadopago_checkout'];
            }
        } elseif (version_compare(_PS_VERSION_, '1.5.0.5') < 0) {
            $logo = Tools::getHttpHost(true, true)._PS_IMG_.'logo.jpg';
        } else {
            $logo = ((bool)Configuration::get('PS_SSL_ENABLED')?'https://':'http://')
                        .preg_replace(
                            '/https?:\/\//i',
                            '',
                            $link->getMediaLink(_PS_IMG_.Configuration::get('PS_LOGO'))
                        );
        }
        if ((bool)Configuration::get('PS_SSL_ENABLED')) {
            $logo = str_replace('http:', 'https:', $logo);
        }
        $rate = $this->getRate($currency->iso_code, $this->settings['CURRENCY']);
        $full_price = $full_total_price * $rate;
        $price = $total_price * $rate;
        //echo "$total_price * $rate => $price - {$currency->iso_code} to {$this->settings['CURRENCY']}";

        //Esto es para incluir el costo de MercadoEnvios en el calculo de comisión.
        $fee_total = $fee * $full_price + $this->config['fee_amount'] - $full_price;

        $unit_price = Tools::ps_round($price + $fee_total, 2);
        //$unit_price = Tools::ps_round($fee * $price + $this->config['fee_amount'], 2);
        $link = new Link();
        $ipn_url = $link->getModuleLink('mpmxs', 'redirect');
        /*
        if (stristr($this->site_url, 'https:') !== false) {
            $ipn_url = 'http://kijam.com/ipn_mercadopago/get_data/'.urlencode(base64_encode($this->site_url.'modules/'.$this->module_name.'/validation.php'));
        } else {
            $ipn_url = $this->site_url.'modules/'.$this->module_name.'/validation.php';
        }
        */
        $max_installments = max(1, min(24, (int)$this->config['max_installments']));
        $mp_unit_price = (float)$unit_price;
        if ($this->settings['UNIT_PRICE_TYPE'] == 'INTEGER') {
            $mp_unit_price = (int)Tools::ps_round($unit_price, 0);
        }
        $preference_data = array(
            'items' => array(
                array(
                    'id' => $params['cart']->id,
                    'title' => "Carrito No: {$params['cart']->id} - {$address->firstname} {$address->lastname}",
                    'quantity' => 1,
                    'currency_id' => $this->settings['CURRENCY'],
                    'unit_price' => $mp_unit_price,
                    'picture_url' => $logo
                )
            ),
            'sponsor_id' => 216274168,
            'back_urls' => array(
                'success'=> $ipn_url,//$this->site_url.'modules/'.$this->module_name.'/return.php',
                'failure'=> $ipn_url,//$this->site_url.'modules/'.$this->module_name.'/return.php',
                'pending'=> $ipn_url//$this->site_url.'modules/'.$this->module_name.'/return.php'
            ),
            'notification_url'=> $ipn_url,
            'external_reference' => $params['cart']->id,
            'payer'=> array(
                'email' => $customer->email,
                'name' =>  $customer->firstname,
                'surname' =>  $customer->lastname
            ),
            'payment_methods'=> array(
                'installments' => $price < $this->config['min_amount_installments']?1:$max_installments,
                'default_installments' => 1
            )
        );
        if ($this->config['auto_return']) {
            $preference_data['auto_return'] = 'approved';
        }
        $products = $params['cart']->getProducts();
        $picture_added = false;
        $is_first_item = true;
        $additional_info = '';
        foreach ($products as &$p) {
            $name_item = $p['name'].(isset($p['attributes']) && !empty($p['attributes'])?' => '. $p['attributes']:'');
            if ($is_first_item) {
                $is_first_item = false;
                $additional_info .= $p['quantity'].' '.$name_item;
            } else {
                $additional_info .= ' - ' . $p['quantity'] . ' ' . $name_item;
            }
            if (!$picture_added && $this->config['image_for_order'] == 'product') {
                $img = false;
                if (version_compare(_PS_VERSION_, '1.5.3.0') >= 0) {
                    $img = ((bool)Configuration::get('PS_SSL_ENABLED')?'https://':'http://')
                                .preg_replace(
                                    '/https?:\/\//i',
                                    '',
                                    $link->getImageLink(
                                        $p['link_rewrite'],
                                        $p['id_image'],
                                        ImageType::getFormatedName('large')
                                    )
                                );
                }
                if (!$img || !$this->urlExists($img)) {
                    $images_type = ImageType::getImagesTypes('products');
                    $image_type = false;
                    foreach ($images_type as $r) {
                        if ($r['width'] > 100) {
                            $image_type = $r['name'];
                            break;
                        }
                    }
                    if ($image_type) {
                        $img = ((bool)Configuration::get('PS_SSL_ENABLED')?'https://':'http://')
                                    .preg_replace(
                                        '/https?:\/\//i',
                                        '',
                                        $link->getImageLink(
                                            $p['link_rewrite'],
                                            $p['id_image'],
                                            ImageType::getFormatedName($image_type)
                                        )
                                    );
                    }
                }
                if ($img && !empty($img) && $this->urlExists($img)) {
                    $preference_data['items'][0]['picture_url'] = $img;
                    $picture_added = true;
                }
            }
            /* $preference_data['items'][] = array(
                'id' => $params['cart']->id.'-' . $p['id_product'] . '-' . $p['id_product_attribute'],
                'title' => $p['name'] . 
                    (isset($p['attributes']) && !empty($p['attributes']) ? ': ' . $p['attributes'] : ''),
                'quantity' => $p['quantity'],
                'picture_url' => ((bool)Configuration::get('PS_SSL_ENABLED')?'https://'
                    .$shop->domain_ssl:'http://')
                    .$link->getImageLink($p['link_rewrite'], $p['id_image'], 'large_default'),
                'currency_id' => $currency->iso_code,
                'unit_price' => 0
            ); */
        }
        $preference_data['additional_info'] = $additional_info;
        $preference_data['items'][0]['title'] = Tools::substr($additional_info, 0, 115);
        if (Tools::strlen($preference_data['items'][0]['title']) < Tools::strlen($additional_info)) {
            $preference_data['items'][0]['title'] .= ' |HAY MAS|';
        }
        if ($this->mercadoenvios_available && $this->config['shipping_active'] && $is_mp_envios) {
            $address = new Address($params['cart']->id_address_delivery);
            $preference_data['shipments'] = array();
            $preference_data['shipments']['mode'] = 'me2';
            $preference_data['shipments']['local_pickup'] = false;
            $products = $params['cart']->getProducts();
            $dim = $this->getWebserviceShippingDim($products);
            $str_dimensions = "{$dim['width']}x{$dim['height']}x{$dim['depth']},{$dim['weight']}";
            $str_zip = preg_replace('/[^0-9]/', '', $address->postcode);
            $str_method = $this->list_shippings['ps_mp'][$params['cart']->id_carrier];
            $preference_data['shipments']['dimensions'] = $str_dimensions;
            $preference_data['shipments']['receiver_address']['zip_code'] = $str_zip;
            $preference_data['shipments']['default_shipping_method'] = $str_method;
            $preference_data['shipments']['free_methods'] = array();
            $list_free_method = array();
            foreach ($this->list_shippings['ps_mp'] as $id_carrier => $cid) {
                $carrier = new Carrier($id_carrier);
                if (!Validate::isLoadedObject($carrier) || $carrier->deleted) {
                    continue;
                }
                if ($carrier->is_free) {
                    $preference_data['shipments']['free_methods'][] = array('id' => (int)$cid);
                    $list_free_method[] = (int)$id_carrier;
                }
            }
            if ($shipping_price < 0.1 && !in_array((int)$params['cart']->id_carrier, $list_free_method)) {
                $id_mp_carrier = (int)$this->list_shippings['ps_mp'][$params['cart']->id_carrier];
                $preference_data['shipments']['free_methods'][] = array('id' => $id_mp_carrier);
            }
        }
        if (!empty($this->config['exclude_payments']) && is_array($this->config['exclude_payments'])) {
            foreach ($this->config['exclude_payments'] as $k => $v) {
                if ((int)$v) {
                    $preference_data['payment_methods']['excluded_payment_types'][] = array('id' => $k);
                }
            }
        }

        $mp_params = array();

        try {
            //print_r($preference_data);
            self::log('preference_data: '.print_r($preference_data, true));
            $preference = $this->api->create_preference($preference_data);
            if ($preference['status'] >= 400) {
                self::log('ERROR-preference_result: '.print_r($preference, true));
                $mp_params['error'] = $this->l('Error conectando a MercadoPago: ').' ['.$preference['status'].']
                - '.$preference['response']['message'];
            }
        } catch (Exception $e) {
            self::log('ERROR-create_preference: '.$e->getFile()."[".$e->getLine()."] -> ".$e->getMessage());
            $mp_params['error'] = $this->l('Error conectando a MercadoPago: ').' ['.$e->getCode().']
                - '.$e->getMessage();
        }
        $famount = $this->config['fee_amount'];
        $ciso = $currency->iso_code;
        $decimals = ($ciso == $this->settings['CURRENCY'] && $this->settings['UNIT_PRICE_TYPE'] == 'INTEGER'?0:2);
        //$mp_params['price']         = $fee * $total_price + $this->config['fee_amount'];
        $mp_params['price']         = $total_price + $fee * $full_total_price - $full_total_price + $famount;
        $mp_params['price']         = Tools::ps_round($mp_params['price'], $decimals);
        $mp_params['is_mp_envios']  = $this->mercadoenvios_available && $this->config['shipping_active'];
        $mp_params['is_mp_envios']  = $mp_params['is_mp_envios'] && $is_mp_envios;
        $mp_params['item_id']       = $params['cart']->id;
        $mp_params['back_url']      = $this->site_url.'modules/'.$this->module_name.'/return.php';
        $mp_params['modal']         = $this->config['modal'];
        $mp_params['mpstyle']       = $this->config['style'];
        $mp_params['mp_country_btn']       = $this->settings['BTN_COUNTRY'];
        if (file_exists(dirname(__FILE__).'/views/img/custom_payment_button.jpg')) {
            if ($this->config['custom_payment_button']) {
                $mp_params['custom_button'] = $this->config['custom_payment_button'];
                $mp_params['custom_button_width'] = $this->config['custom_payment_button_size'][0];
            } else {
                $mp_params['custom_button'] = false;
            }
        } else {
            $mp_params['custom_button'] = false;
        }
        $mp_params['init_point']    = $preference['status'] >= 400?false:$preference['response']['init_point'];
        $mp_params['fee']           = $this->config['fee'];
        $mp_params['fee_amount']    = $this->config['fee_amount'];
        $mp_params['feeTotal']      = $mp_params['price'] - $total_price;
        $mp_params['shippingTotal'] = $shipping_price;
        $mp_params['newPrice']      = $mp_params['price'] + $shipping_price;
        $mp_params['installment_calculator'] = false;
        if (isset($this->config['installment_calculator'])) {
            $mp_params['installment_calculator'] = $this->config['installment_calculator'];
        }
        return $mp_params;
    }
    public function paymentButton17($params, $context)
    {
        
        $result = $this->paymentButton($params);
        if (!is_array($result) || !isset($result['init_point'])) {
            return array();
        }
        $context->smarty->assign($result);
        if (!class_exists('PaymentOptionKijam')) {
            include_once(dirname(__FILE__).'/paymentoption.php');
        }
        $newOption = PaymentOptionKijam::getInstance();
        $newOption->setCallToActionText($this->l('Payment with MercadoPago'))
                    ->setAction($result['init_point'])
                    ->setAdditionalInformation(
                        $context->smarty->fetch('module:'.$this->module_name.'/views/templates/hook/mp17.tpl')
                    );
        $payment_options = array(
            $newOption,
        );
        return $payment_options;
    }
    public function hookDisplayProductButtons($params)
    {
        if (!isset($params['product'])) {
            $params['product'] = new Product((int)Tools::getValue('id_product'));
        } elseif (is_array($params['product'])) {
            $params['product'] = new Product((int)$params['product']['id_product']);
        }
        if (!$this->api_me
            || !$this->mercadoenvios_available
            || !$this->config['shipping_active']
            || !$this->config['ship_check_price']) {
            if (isset($this->config['installment_calculator']) && $this->config['installment_calculator']) {
                return array(
                    'backwardcompatible' => version_compare(_PS_VERSION_, '1.6') < 0,
                    'installment_calculator' => $this->config['installment_product_calculator'],
                    'id_product' => $params['product']->id,
                    'price' => $params['product']->getPrice(true, false)
                );
            } else {
                return array();
            }
        }
    }

    
    /*******************************************************/
    /*******************************************************/
    /******** DESDE AQUI VA TODO LO RELACIONADO ************/
    /************* AL ADMIN DE PRESTASHOP ******************/
    /*******************************************************/
    /*******************************************************/
    public function hookBackOfficeHeader($params, $smarty, $file_template)
    {
        $ps_version = 1.6;
        if (version_compare(_PS_VERSION_, '1.6') < 0) {
            $ps_version = 1.5;
        }
        if (version_compare(_PS_VERSION_, '1.7.0.0') >= 0) {
            $ps_version = 1.7;
        }
        $smarty->assign('ps_version', $ps_version);
        $smarty->assign('new_ps_version', version_compare(_PS_VERSION_, '1.5.0.0') >= 0);
        if (!isset($this->list_shippings['mp_ps']) || count($this->list_shippings['mp_ps']) < 1) {
            $smarty->assign('list_shippings', false);
        } else {
            $smarty->assign('list_shippings', implode(',', $this->list_shippings['mp_ps']));
        }
        return $this->instance_module->display($file_template, 'views/templates/admin/header.tpl');
    }
    private function updateConfig($file_template)
    {
        $errors = '';
        if (Tools::isSubmit('client_id') && Tools::isSubmit('client_secret')) {
            $ui_error = $this->instance_module->display($file_template, 'views/templates/admin/errors.tpl');
            Db::getInstance()->Execute('DELETE FROM `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'_cache`');
            $reload_api = true;
            if (!isset($this->config['client_id'])
                || $this->config['client_id'] != trim(Tools::getValue('client_id'))) {
                $reload_api = true;
            }
            if (!isset($this->config['client_secret'])
                || $this->config['client_secret'] != trim(Tools::getValue('client_secret'))) {
                $reload_api = true;
            }
            $this->config['client_id'] = trim(Tools::getValue('client_id'));
            $this->config['client_secret'] = trim(Tools::getValue('client_secret'));
            $this->config['publickey'] = trim(Tools::getValue('publickey'));
            $this->config['installment_calculator'] = (bool)Tools::getValue('installment_calculator');
            $this->config['installment_product_calculator'] = (bool)Tools::getValue('installment_product_calculator');
            $this->config['debug'] = (bool)Tools::getValue('debug');
            if (Tools::isSubmit('fee')) {
                $this->config['fee'] = (float)Tools::getValue('fee');
                $this->config['fee_amount'] = (float)Tools::getValue('fee_amount');
                if (Tools::isSubmit('exclude_payments')) {
                    $this->config['exclude_payments'] = (array)Tools::getValue('exclude_payments');
                } else {
                    $this->config['exclude_payments'] = array();
                }
                $dest = dirname(__FILE__).'/views/img/custom_payment_button.jpg';
                if (isset($_FILES['file_custom_button'])) {
                    $file = $_FILES['file_custom_button']['tmp_name'];
                    if ((bool)Tools::getValue('custom_payment_button') && @file_exists($file)) {
                        $imagesizedata = @getimagesize($file);
                        if ($imagesizedata !== false) {
                            @unlink($dest);
                            if (@move_uploaded_file($_FILES['file_custom_button']['tmp_name'], $dest)) {
                                $this->config['custom_payment_button'] = $this->site_url.'modules/'.$this->module_name
                                                                            .'/views/img/custom_payment_button.jpg';
                                $this->config['custom_payment_button_size'] = $imagesizedata;
                            } else {
                                $errors .= sprintf($ui_error, $this->l('Error uploading you custom imagen.'));
                            }
                        } else {
                            $errors .= sprintf($ui_error, $this->l('Your file not is a valid image.'));
                        }
                    }
                }
                if ((bool)Tools::getValue('custom_payment_button') && @file_exists($dest)) {
                    $this->config['custom_payment_button'] = $this->site_url.'modules/'.$this->module_name
                                                                .'/views/img/custom_payment_button.jpg';
                } else {
                    $this->config['custom_payment_button'] = false;
                }
                if (isset($_FILES['file_mercadopago_checkout'])) {
                    $file = $_FILES['file_mercadopago_checkout']['tmp_name'];
                    if (@file_exists($file)) {
                        $imagesizedata = @getimagesize($file);
                        if ($imagesizedata !== false) {
                            $dest = '/views/img/logo_mercadopago_checkout_'.rand().'.jpg';
                            $tmp_name = $_FILES['file_mercadopago_checkout']['tmp_name'];
                            if (@move_uploaded_file($tmp_name, dirname(__FILE__).$dest)) {
                                $this->config['logo_mercadopago_checkout'] = $dest;
                                if (isset($imagesizedata[3])) {
                                    unset($imagesizedata[3]);
                                }
                                $this->config['logo_mercadopago_checkout_size'] = $imagesizedata;
                            } else {
                                $errors .= sprintf($ui_error, $this->l('Error uploading you logo.'));
                            }
                        } else {
                            $errors .= sprintf($ui_error, $this->l('Your logo not is a valid image.'));
                        }
                    }
                }
                $cond = !isset($this->config['logo_mercadopago_checkout']);
                $cond = $cond || empty($this->config['logo_mercadopago_checkout']);
                if ($cond || !@file_exists(dirname(__FILE__).$this->config['logo_mercadopago_checkout'])) {
                    $org = null;
                    if (version_compare(_PS_VERSION_, '1.5.0.5') < 0) {
                        $org = Tools::getHttpHost(true, true)._PS_IMG_.'logo.jpg';
                    } else {
                        $link = new Link();
                        $link_logo = _PS_IMG_.Configuration::get('PS_LOGO');
                        $org = ((bool)Configuration::get('PS_SSL_ENABLED')?'https://':'http://')
                                    .preg_replace('/https?:\/\//i', '', $link->getMediaLink($link_logo));
                    }
                    $dest = '/views/img/logo_mercadopago_checkout_'.rand().'.jpg';
                    @file_put_contents(dirname(__FILE__).$dest, @Tools::file_get_contents($org));
                    $imagesizedata = @getimagesize(dirname(__FILE__).$dest);
                    if ($imagesizedata !== false) {
                        $this->config['logo_mercadopago_checkout'] = $dest;
                        if (isset($imagesizedata[3])) {
                            unset($imagesizedata[3]);
                        }
                        $this->config['logo_mercadopago_checkout_size'] = $imagesizedata;
                    } else {
                        $this->config['logo_mercadopago_checkout'] = $org;
                    }
                }
                $this->config['image_for_order'] = (string)Tools::getValue('image_for_order');
                $this->config['style'] = (array)Tools::getValue('style');
                $this->config['os_authorization'] = (int)Tools::getValue('os_authorization');
                $this->config['os_refused'] = (int)Tools::getValue('os_refused');
                $this->config['status_refound'] = (array)Tools::getValue('status_refound');
                $this->config['modal'] = (bool)Tools::getValue('modal');
                $this->config['auto_return'] = (bool)Tools::getValue('auto_return');
                $this->config['min_amount_installments'] = (float)Tools::getValue('min_amount_installments');
                $this->config['max_installments'] = (int)Tools::getValue('max_installments');
                $this->config['shipping_active'] = false;
            }
            if (version_compare(_PS_VERSION_, '1.5.0.9') >= 0) {
                //echo 'AAAAAAAA';
                //$r =
                Configuration::updateValue(
                    $this->module_name.'kijam_config',
                    Tools::jsonEncode($this->config),
                    false,
                    $this->id_shop_group,
                    $this->id_shop
                );
                //echo var_dump($this->id_shop_group);
                //echo var_dump($this->id_shop);
                //echo var_dump($r);
            } else {
                Configuration::updateValue($this->module_name.'kijam_config', Tools::jsonEncode($this->config));
            }
            if ($reload_api) {
                if (version_compare(_PS_VERSION_, '1.5.1.0') >= 0) {
                    $id_country = Country::getByIso($this->settings['ISO']);
                    Country::addModuleRestrictions(
                        array(),
                        array(array('id_country'=>$id_country)),
                        array(array('id_module'=>$this->instance_module->id))
                    );
                }
                $this->api = new MercadoPagoGenericMpmxs($this->config['client_id'], $this->config['client_secret']);
                $this->verifyMercadoPago(true);
                if (!$this->api_me) {
                    $errors .= sprintf($ui_error, $this->l('Your client_id or client_secret invalid.'));
                } else {
                    if ($this->api_me['site_id'] != $this->site_id) {
                        $errors .= sprintf($ui_error, sprintf(
                            $this->l('Your client_id or client_secret is for %s, this module required %s.'),
                            $this->api_me['site_id'],
                            $this->site_id
                        ));
                        $this->api_me = null;
                        $this->api = null;
                    }
                    $this->verifyTestUser();
                }
            }
        }
        return $errors;
    }

    public function adminPage($smarty, $file_template)
    {
        $ps_version = 1.6;
        if (version_compare(_PS_VERSION_, '1.6') < 0) {
            $ps_version = 1.5;
        }
        if (version_compare(_PS_VERSION_, '1.7.0.0') >= 0) {
            $ps_version = 1.7;
        }
        $smarty->assign('ps_version', $ps_version);
        $smarty->assign('riot_compiler_url', $this->instance_module->getPathTemplate().'views/js/riot.compiler.min.js');
        $ui_alerts = $this->instance_module->display($file_template, 'views/templates/admin/prestui/ps-alert.tpl');
        $ui_riot   = $this->instance_module->display($file_template, 'views/templates/admin/libs.tpl');
        $b64_riot   = $this->instance_module->display($file_template, 'views/templates/admin/b64_riot.tpl');
        if (version_compare(_PS_VERSION_, '1.5.0.9') >= 0) {
            $str = $this->getWarningMultishopHtml($file_template);
            if ((bool)Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE')
                && (Shop::getContext() == Shop::CONTEXT_GROUP
            || Shop::getContext() == Shop::CONTEXT_ALL)) {
                $html = htmlentities($str.$this->getShopContextError($file_template));
                return sprintf($b64_riot, $html.$ui_alerts).$ui_riot;
            }
        }
        //print_r($this->config);
        $str = $this->updateConfig($file_template);
        //print_r($this->config);
        $order_states = OrderState::getOrderStates($this->context->employee->id_lang);

        if (!isset($this->config['fee'])) {
            $this->config['os_authorization'] = (int)Configuration::get('PS_OS_PAYMENT');
            $this->config['os_refused'] = (int)Configuration::get('PS_OS_ERROR');
            $this->config['status_refound'] = array(
                (int)Configuration::get('PS_OS_CANCELED'),
                (int)Configuration::get('PS_OS_REFUND')
            );
            $this->config['max_installments'] = 24;
            $this->config['min_amount_installments'] = 0;
            $this->config['fee'] = 0;
            $this->config['fee_amount'] = 0;
            $this->config['default_weight'] = 100;
            $this->config['default_width'] = 10;
            $this->config['default_height'] = 10;
            $this->config['default_depth'] = 10;
            $this->config['auto_return'] = true;
        }
        if (!isset($this->config['style'])
            || !isset($this->config['style']['b_color'])
            || empty($this->config['style']['b_color'])) {
            $this->config['style'] = array(
                'b_color' => 'blue',
                'b_size' => 'M',
                'b_shape' => 'Ov',
                'b_font' => 'Ar',
                'b_logo' => 'On',
            );
        }
        if (!isset($this->config['logo_mercadopago_checkout']) || empty($this->config['logo_mercadopago_checkout'])) {
            $org = null;
            if (version_compare(_PS_VERSION_, '1.5.0.5') < 0) {
                $org = Tools::getHttpHost(true, true)._PS_IMG_.'logo.jpg';
            } else {
                $link = new Link();
                $ps_logo_url = _PS_IMG_.Configuration::get('PS_LOGO');
                $org = ((bool)Configuration::get('PS_SSL_ENABLED')?'https://':'http://');
                $org .= preg_replace('/https?:\/\//i', '', $link->getMediaLink($ps_logo_url));
            }
            $dest = '/views/img/logo_mercadopago_checkout_'.rand().'.jpg';
            @file_put_contents(dirname(__FILE__).$dest, @Tools::file_get_contents($org));
            $imagesizedata = @getimagesize(dirname(__FILE__).$dest);
            if ($imagesizedata !== false) {
                $this->config['logo_mercadopago_checkout'] = $dest;
                if (isset($imagesizedata[3])) {
                    unset($imagesizedata[3]);
                }
                $this->config['logo_mercadopago_checkout_size'] = $imagesizedata;
            } else {
                $this->config['logo_mercadopago_checkout'] = $org;
            }
        }
        if (Tools::strtolower(Tools::substr($this->config['logo_mercadopago_checkout'], 0, 4)) != 'http') {
            $logo_url = $this->site_url.'modules/'.$this->module_name.$this->config['logo_mercadopago_checkout'];
            $this->config['logo_mercadopago_checkout'] = $logo_url;
        }
        $groups = Group::getGroups(Context::getContext()->language->id);
        //print_r($groups);
        //print_r($this->settings);
        //print_r($this->test_user);
        $smarty->assign($this->config);
        $smarty->assign('settings', $this->settings);
        $smarty->assign('display_name', $this->instance_module->displayName);
        $smarty->assign('api_me', $this->verifyMercadoPago(true));
        $smarty->assign('log_path', '/modules/'.$this->module_name.'/logs/');
        $smarty->assign('order_states', $order_states);
        $smarty->assign('mercadoenvios_available', $this->mercadoenvios_available);
        $smarty->assign('client_groups', $groups);
        $smarty->assign('test_user', $this->test_user);
        
        $html = $this->instance_module->display($file_template, 'views/templates/admin/config.tpl');
        $ui_form = $this->instance_module->display($file_template, 'views/templates/admin/prestui/ps-form.tpl');
        $ui_panel = $this->instance_module->display($file_template, 'views/templates/admin/prestui/ps-panel.tpl');

        return sprintf($b64_riot, htmlentities($str.$html).$ui_panel.$ui_form.$ui_alerts).$ui_riot;
    }

    /*******************************************************/
    /*******************************************************/
    /******** DESDE AQUI VA TODO LO RELACIONADO ************/
    /************ HERRAMIENTAS Y UTILIDADES ****************/
    /*******************************************************/
    /*******************************************************/
    public static function log($data)
    {
        if (!is_null(self::$instance)) {
            if (isset(self::$instance->config['debug']) && !self::$instance->config['debug']) {
                return;
            }
        } else {
            return;
        }
        if (!is_dir(dirname(__FILE__).'/logs')) {
            @mkdir(dirname(__FILE__).'/logs');
        }

        if (!is_dir(dirname(__FILE__).'/logs/'.date('Y-m'))) {
            @mkdir(dirname(__FILE__).'/logs/'.date('Y-m'));
        }

        $fp = fopen(dirname(__FILE__).'/logs/'.date('Y-m').'/log-'.date('Y-m-d').'.log', 'a');

        fwrite($fp, "\n----- ".date('Y-m-d H:i:s')." -----\n");
        fwrite($fp, $data);
        fclose($fp);
    }
    public function l($key)
    {
        if ($this->instance_module) {
            return $this->instance_module->lang($key, 'mercadopago_gateway');
        }
        return $key;
    }
    public function getRate($from, $to)
    {
        $from = Tools::strtoupper($from);
        $to = Tools::strtoupper($to);

        if ($from == $to) {
            return 1.0;
        }
        $id_from = Currency::getIdByIsoCode($from);
        $id_to = Currency::getIdByIsoCode($to);
        if ($id_from * $id_to > 0) {
            $currency_from = new Currency((int)$id_from);
            $currency_to = new Currency((int)$id_to);
            $result = $currency_to->conversion_rate / $currency_from->conversion_rate;
            self::log(
                "getRate($from -> $to) ==> from ps: 
                {$currency_to->conversion_rate} / {$currency_from->conversion_rate} = {$result}"
            );
            return (float)$result;
        }
        if (isset($this->currency_convert[$from])
                && isset($this->currency_convert[$from][$to])
                && $this->currency_convert[$from][$to]['time'] > time() - 60 * 60 * 12) {
            $result = $this->currency_convert[$from][$to]['rate'];
            self::log("getRate($from -> $to) ==> from cache yahoo: {$result}");
            return (float)$result;
        }
        $headers = array(
                'Accept:text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
                'Host:download.finance.yahoo.com',
                'Connection:keep-alive',
                'Connection:keep-alive',
                'User-Agent:Mozilla/5.0 (Windows NT 6.3) AppleWebKit/53 (KHTML, like Gecko) Chrome/37 Safari/537.36');

        $ch = curl_init('http://download.finance.yahoo.com/d/quotes.csv?e=.csv&f=l1&s='.$from.$to.'=X');
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($ch);
        $this->currency_convert[$from][$to]['time'] = time();
        $this->currency_convert[$from][$to]['rate'] = (float)$result;

        if (version_compare(_PS_VERSION_, '1.5.0.9') >= 0) {
            Configuration::updateValue(
                $this->module_name.'kijam_currency_convert',
                Tools::jsonEncode($this->currency_convert),
                false,
                $this->id_shop_group,
                $this->id_shop
            );
        } else {
            Configuration::updateValue(
                $this->module_name.'kijam_currency_convert',
                Tools::jsonEncode($this->currency_convert)
            );
        }
        $result = $this->currency_convert[$from][$to]['rate'];
        self::log("getRate($from -> $to) ==> from yahoo: {$result}");
        return $result;
    }
    public static function getCache($cache_id)
    {
        if (self::$instance && self::$instance->api_me) {
            $cache_id .= self::$instance->config['client_id'];
        }
        $data = false;
        if (isset(self::$mp_cache[$cache_id]) && ($data = self::$mp_cache[$cache_id])) {
            return $data;
        }
        if (defined('_PS_CACHE_ENABLED_') && _PS_CACHE_ENABLED_) {
            $cache = Cache::getInstance();
            if ($data = $cache->get($cache_id)) {
                return $data;
            }
        }
        try {
            Db::getInstance()->Execute('DELETE FROM `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'_cache`
                    WHERE ttl < '.(int)time());
            $d = Db::getInstance()->getValue('SELECT `data` FROM `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'_cache`
                    WHERE `cache_id` = \''.pSQL($cache_id).'\'');
        } catch (PrestaShopDatabaseException $e) {
            return false;
        }
        if ($d) {
            $data = unserialize($d);
        }
        return $data;
    }
    public static function setCache($cache_id, $value, $ttl = 600)
    {
        if (self::$instance && self::$instance->api_me) {
            $cache_id .= self::$instance->config['client_id'];
        }
        self::$mp_cache[$cache_id] = $value;
        if (defined('_PS_CACHE_ENABLED_') && _PS_CACHE_ENABLED_) {
            $cache = Cache::getInstance();
            if ($cache->set($cache_id, $value, $ttl)) {
                return true;
            }
        }
        try {
            Db::getInstance()->Execute('DELETE FROM `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'_cache`
                    WHERE ttl < '.(int)time().' OR cache_id = \''.pSQL($cache_id).'\'');
            return Db::getInstance()->Execute('INSERT IGNORE INTO `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'_cache`
                        (`cache_id`, `data`, `ttl`) VALUES
                        (\''.pSQL($cache_id).'\',
                         \''.pSQL(serialize($value)).'\',
                         '.(int)(time() + $ttl).')');
        } catch (PrestaShopDatabaseException $e) {
            return false;
        }
    }
    protected function getWarningMultishopHtml($file_template)
    {
        if ((bool)Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE')
            && (Shop::getContext() == Shop::CONTEXT_GROUP
            || Shop::getContext() == Shop::CONTEXT_ALL)) {
            $ui_warning = $this->instance_module->display($file_template, 'views/templates/admin/alerts.tpl');
            return sprintf(
                $ui_warning,
                'warning',
                $this->l('You cannot change setting from a "All Shops" or a "Group Shop" context, select directly the shop you want to edit')
            );
        } else {
            return '';
        }
    }
    protected function getShopContextError($file_template)
    {
        $ui_warning = $this->instance_module->display($file_template, 'views/templates/admin/alerts.tpl');
        return sprintf(
            $ui_warning,
            'danger',
            sprintf($this->l('You cannot edit setting from a "All Shops" or a "Group Shop" context'))
        );
    }
}
