{*
* Template para MercadoPago
*
* @author     Modulo MercadoPago>
* @copyright Kubo Digital
* @license   Comercial
*}
<style>
    #MP-Checkout-dialog {
        z-index: 200000 !important;
    }
    #botonMP {
        padding: 0;
        padding-left: 20px;
        padding-right: 20px;
    }
</style>
{if $publickey}
<script src="https://secure.mlstatic.com/sdk/javascript/v1/mercadopago.js"></script>
<script>
    Mercadopago.setPublishableKey("{$publickey|escape:'htmlall':'UTF-8'}");
    function calcInstallments(credit_card, price) {
        if (credit_card.length != 6) {
            $("#result_installments").html("<b style=\'color:red\'>{l s='You must enter the first six digits of your card' mod='mpmxs'}</b>");
        } else {
            $("#result_installments").html("{l s='Loading...' mod='mpmxs'}");
            Mercadopago.getInstallments(
                {
                    "bin": credit_card,
                    "amount": price
                },
                function(status, data) {
                    var html = "";
                    if (status != 200) {
                        html = "<b style=\'color:red\'>{l s='Error on MercadoPago or your Credit Card is invalid. Technical details:' mod='mpmxs'} " + data.cause[0].code + " -> " + data.cause[0].description+"</b>";
                    } else {
                        html += "<ul style=\"list-style-type: disc;list-style-position: outside;list-style-image: none;\">";
                        for (var i in data[0].payer_costs) {
                            var cost = data[0].payer_costs[i];
                            html += "<li>"+cost.recommended_message;
                            if (cost.labels && cost.labels.length > 0) {
                                for(var j in cost.labels) {
                                    if (cost.labels[j].indexOf("CFT") >= 0 || cost.labels[j].indexOf("TEA") >= 0)
                                        html += ", "+cost.labels[j].replace(/_+/ig, " ").replace(/\|/ig, ", ");
                                }
                            }
                            html += "</li>";
                        }
                        html += "</ul>";
                    }
                    $("#result_installments").html(html);
                    console.log(html);
                }
            );
        }
    }
</script>
{else}
<script>
    setInterval(function(){
        if ("undefined" != typeof window.jQuery) {
            if($("#is_mercadopago").length > 0 && !$("#is_mercadopago").hasClass("mp_reload_renderjs")) {
                $("#mp_render_script").remove();
                $("#is_mercadopago").addClass("mp_reload_renderjs");
                $.getScript("https://www.mercadopago.com/org-img/jsapi/mptools/buttons/render.js?s=" + Math.random(), function() {
                    $("script:last").attr("id", "mp_render_script");
                });
            }
        }
    }, 1000);
</script>
{/if}