<?php
/**
* Modulo MercadoPago
*
* @author     Modulo MercadoPago>
* @copyright Kubo Digital
* @license   Commercial use allowed (Non-assignable & non-transferable), can modify source-code but cannot distribute modifications (derivative works).
*/

class Mpmxs extends PaymentModule
{
    const GATEWAY_NAME = 'MLM';
    public $id_carrier;
    public $gateway = null;

    public function __construct()
    {
        $this->name = 'mpmxs';
        $this->tab = 'payments_gateways';
        $this->version = '4.1.1';
        $this->author = 'KD';
        $this->module_key = '0c9b3a49a449e263262a1357eb636252';

        if (version_compare(_PS_VERSION_, '1.6.0.0') >= 0) {
            $this->bootstrap = true;
        }

        parent::__construct();

        $this->displayName = $this->l('MercadoPago %s Pro');
        $this->description = $this->l('MercadoPago platform valid payment for %s');

        if (!defined('_PS_VERSION_')) {
            exit;
        }

        /** Backward compatibility */
        if (version_compare(_PS_VERSION_, '1.5') < 0) {
            require(_PS_MODULE_DIR_.$this->name.'/backward_compatibility/backward.php');
        }
        if (Module::isInstalled($this->name)) {
            if (!class_exists('MercadoPagoGatewayKijamMpmxs')) {
                include_once(dirname(__FILE__).'/mercadopago_gateway.php');
            }
            $this->gateway = MercadoPagoGatewayKijamMpmxs::getInstance(self::GATEWAY_NAME, $this->name, $this);
            if ($this->gateway) {
                $this->warning .= $this->gateway->warning;
                $settings = $this->gateway->getSettings();
                $this->displayName = sprintf($this->displayName, $settings['NAME']);
                $this->description = sprintf($this->description, $settings['NAME']);
                $this->limited_countries = array(Tools::strtolower($settings['ISO']));
            }
        } else {
            $data = include(dirname(__FILE__).'/data-mp-countries.php');
            $settings = $data[Tools::strtoupper(self::GATEWAY_NAME)];
            $this->displayName = sprintf($this->displayName, $settings['NAME']);
            $this->description = sprintf($this->description, $settings['NAME']);
            $this->limited_countries = array(Tools::strtolower($settings['ISO']));
        }
        /* For 1.4.3 and less compatibility */
        $update_config = array('PS_OS_CHEQUE',
                            'PS_OS_PAYMENT',
                            'PS_OS_PREPARATION',
                            'PS_OS_SHIPPING',
                            'PS_OS_CANCELED',
                            'PS_OS_REFUND',
                            'PS_OS_ERROR',
                            'PS_OS_OUTOFSTOCK',
                            'PS_OS_BANKWIRE',
                            'PS_OS_PAYPAL',
                            'PS_OS_WS_PAYMENT');

        foreach ($update_config as $u) {
            if (!Configuration::get($u) && defined('_'.$u.'_')) {
                Configuration::updateValue($u, constant('_'.$u.'_'));
            }
        }
    }
    
    public function install()
    {
        $incompatible_found = false;
        if (!function_exists('curl_version')) {
            $this->_errors[] = $this->l('Curl not installed');
            $incompatible_found = true;
        }
        /*
        $imcompatible_modules = array(
            'mpmxs' => 'MercadoPago Mexico Pro',
            'mpar' => 'MercadoPago Argentina Pro',
            'mpco' => 'MercadoPago Colombia Pro',
            'mpcl' => 'MercadoPago Chile Pro',
            'mppe' => 'MercadoPago Peru Pro',
            'mpuy' => 'MercadoPago Uruguay Pro',
            'mpve' => 'MercadoPago Venezuela Pro'//,
            //'mercadopago' => 'MercadoPago Official'
        );
		foreach ($imcompatible_modules as $m_name => $m_human_name) {
            if ($this->name != $m_name && Module::isInstalled($m_name)) {
                $this->_errors[] = sprintf(
                    $this->l('Please uninstall the module "%s" (%s) for use this.'),
                    $m_human_name,
                    $m_name
                );
                $incompatible_found = true;
            }
        }
		*/
        if ($incompatible_found) {
            return false;
        }

        

        if (!class_exists('MercadoPagoGatewayKijamMpmxs')) {
            include_once(dirname(__FILE__).'/mercadopago_gateway.php');
        }

        $this->gateway = MercadoPagoGatewayKijamMpmxs::getInstance(self::GATEWAY_NAME, $this->name, $this);
        $db_created = $this->gateway->installDb();

        if (!$db_created) {
            $this->_errors[] = $this->l('Failed to create the table in the Database');
        }

        $is_14 = version_compare(_PS_VERSION_, '1.5.0.0') < 0;
        $is_16 = version_compare(_PS_VERSION_, '1.6.0.0') >= 0;
        $is_17 = version_compare(_PS_VERSION_, '1.7.0.0') >= 0;
        $is_171 = version_compare(_PS_VERSION_, '1.7.1.0') >= 0;
        $result = $db_created && parent::install()
            && $this->registerHook('orderConfirmation')
            && $this->registerHook('payment')
            && $this->registerHook('updateOrderStatus')
            && ($is_14?$this->registerHook('adminOrder'):$this->registerHook('displayAdminOrder'))
            && ($is_14?$this->registerHook('header'):$this->registerHook('displayHeader'))
            && ($is_14?$this->registerHook('backOfficeHeader'):$this->registerHook('displayBackOfficeHeader'))
            && ($is_171?$this->registerHook('displayProductAdditionalInfo'):($is_14?$this->registerHook('productActions'):$this->registerHook('displayProductButtons')))
            
            && ($is_14?$this->registerHook('PDFInvoice'):$this->registerHook('displayPDFInvoice'))
            && ($is_16?$this->registerHook('dashboardZoneOne'):true)
            && ($is_16?$this->registerHook('dashboardData'):true)
            && ($is_17?$this->registerHook('paymentOptions'):true);

        if (!$result && $db_created) {
            $this->gateway->uninstall();
        }

        if ($result) {
            @chmod(dirname(__FILE__).'/', 0755);
        }

        return $result;
    }
    public function uninstall()
    {
        if ($this->gateway) {
            $this->gateway->uninstall();
        }
        return parent::uninstall();
    }
    public function hookDisplayPDFInvoice($params)
    {
        $order_invoice = $params['object'];
        if (!Validate::isLoadedObject($order_invoice) || !isset($order_invoice->id_order)) {
            return;
        }
        return $this->gateway?$this->gateway->hookDisplayPDFInvoice($params):'';
    }
    public function hookPDFInvoice($params)
    {
        return $this->hookDisplayPDFInvoice($params);
    }
    public function hookDisplayProductButtons($params)
    {
        if (!$this->gateway) {
            return;
        }
        $result = $this->gateway->hookDisplayProductButtons($params);
        if (is_array($result) && count($result) > 0) {
            $this->context->smarty->assign($result);
            return $this->display(__FILE__, 'views/templates/hook/productactions.tpl');
        }
    }
    public function hookDisplayProductAdditionalInfo($params)
    {
        return $this->hookDisplayProductButtons($params);
    }
    public function hookProductActions($params)
    {
        return $this->hookDisplayProductButtons($params);
    }
    
    public function hookDashboardZoneOne($params)
    {
        return $this->display(__FILE__, 'views/templates/hook/dashboard_zone_one.tpl');
    }
    public function hookDashboardData($params)
    {
        $balance = false;
        if ($this->gateway) {
            $balance = $this->gateway->getBalance();
        }
        if ($balance) {
            return array(
                'data_value' => array(
                    $this->name.'_total_amount' => $balance['total_amount'].' '.$balance['currency_id'],
                    $this->name.'_available_balance' => $balance['available_balance'].' '.$balance['currency_id'],
                    $this->name.'_unavailable_balance' => $balance['unavailable_balance'].' '.$balance['currency_id'],
                ),
                'data_trends' => array(
                ),
                'data_list_small' => array(
                ),
                'data_chart' => array(
                ),
            );
        } else {
            return array(
                'data_value' => array(
                    $this->name.'_total_amount' => '-',
                    $this->name.'_available_balance' => '-',
                    $this->name.'_unavailable_balance' => '-',
                ),
                'data_trends' => array(
                ),
                'data_list_small' => array(
                ),
                'data_chart' => array(
                ),
            );
        }
    }
    public function hookDisplayHeader($params)
    {
        return $this->hookHeader($params);
    }
    public function hookHeader($params)
    {
        if (!$this->gateway) {
            return '';
        }
        $result = $this->gateway->cronjob($this->smarty, __FILE__);
        $config = $this->gateway->getConfig();
        if (isset($config['shipping_active']) && (bool)$config['shipping_active']) {
            Context::getContext()->controller->addJS(($this->_path).'views/js/check_price.js');
        }
        return $result;
    }
    public function hookDisplayBackOfficeHeader($params)
    {
        return $this->hookBackOfficeHeader($params);
    }
    public function hookBackOfficeHeader($params)
    {
        if ($this->gateway && ($result = $this->gateway->hookBackOfficeHeader($params, $this->smarty, __FILE__))) {
            return $result;
        }
        return '';
    }
    public function hookDisplayAdminOrder($params)
    {
        if (!isset($params['id_order']) || !$this->gateway) {
            return '';
        }
        if ($result = $this->gateway->hookDisplayAdminOrder($params, __FILE__)) {
            $this->context->smarty->assign($result);
            return $this->display(__FILE__, 'views/templates/hook/displayAdminOrder.tpl');
        }
        return '';
    }
    public function hookAdminOrder($params)
    {
        return $this->hookDisplayAdminOrder($params);
    }
    public function hookOrderConfirmation($params)
    {
        if (!$this->active || !$this->gateway) {
            return;
        }
        $order = null;
        if (isset($params['objOrder'])) {
            $order = $params['objOrder'];
        } elseif (isset($params['order'])) {
            $order = $params['order'];
        } else {
            return;
        }
        if ($order->module != $this->name) {
            return;
        }
        $this->context->smarty->assign($this->gateway->hookOrderConfirmation($order));
        return $this->display(__FILE__, 'views/templates/hook/hookorderconfirmation.tpl');
    }
    public function getContent()
    {
        if (!$this->gateway) {
            return;
        }
        return $this->gateway->adminPage($this->smarty, __FILE__);
    }
    public function getPathTemplate()
    {
        return $this->_path;
    }
    public function hookPayment($params)
    {
        if ($this->gateway && ($result = $this->gateway->paymentButton($params))) {
            $this->context->smarty->assign($result);
            return $this->display(__FILE__, 'views/templates/hook/mp.tpl');
        }
        return '';
    }
    public function hookPaymentOptions($params)
    {
        if (!$this->active) {
            return;
        }
        if ($this->gateway && ($result = $this->gateway->paymentButton17($params, $this->context))) {
            return $result;
        }
        return array();
    }
    public function hookUpdateOrderStatus($params)
    {
        if ($this->gateway && ($result = $this->gateway->hookUpdateOrderStatus($params))) {
            return $result;
        }
        return '';
    }
    public function lang($str, $specific = false)
    {
        return $this->l($str, $specific);
    }
}
