<?php
/**
* Modulo MercadoPago
*
* @author     Modulo MercadoPago>
* @copyright Kubo Digital
* @license   Comercial
*/

if (!defined('_PS_VERSION_')) {
    exit;
}



/**

 * Array of settings

 */

return array(
    'MLA'          => array(
        'NAME' => 'Argentina',
        'CURRENCY' => 'ARS',
        'ISO' => 'AR',
        'BTN_COUNTRY' => 'Ar',
        'UNIT_PRICE_TYPE' => 'FLOAT',
        'REGISTER_URL' => 'https://www.mercadopago.com/mla/registration',
        'SECRET_URL' => 'https://www.mercadolibre.com/jms/mla/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mla/herramientas/aplicaciones',
        'IPN_URL' => 'https://www.mercadolibre.com/jms/mla/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mla/herramientas/notificaciones',
        'MPENVIOS_REGISTER_URL' => 'http://envios.mercadolibre.com.ar/optin/doOptin',
        'PUBLICKEY_URL' => 'https://www.mercadolibre.com/jms/mla/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mla/account/credentials',
        'MP_SHIPPING_MIN_W' => 10,
        'MP_SHIPPING_MAX_W' => 70,
        'MP_SHIPPING_MIN_H' => 10,
        'MP_SHIPPING_MAX_H' => 70,
        'MP_SHIPPING_MIN_D' => 10,
        'MP_SHIPPING_MAX_D' => 70,
        'MP_SHIPPING_MIN_WE' => 100,
        'MP_SHIPPING_MAX_WE' => 25000,
        'ACCEPT_DIGITAL_CURRENCY' => false
    ),
    'MLM'          => array(
        'NAME' => 'Mexico',
        'CURRENCY' => 'MXN',
        'ISO' => 'MX',
        'BTN_COUNTRY' => 'Mx',
        'UNIT_PRICE_TYPE' => 'FLOAT',
        'REGISTER_URL' => 'https://www.mercadopago.com/mlm/registration',
        'SECRET_URL' => 'https://www.mercadolibre.com/jms/mlm/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlm/herramientas/aplicaciones',
        'IPN_URL' => 'https://www.mercadopago.com/mlm/herramientas/notificaciones',
        'MPENVIOS_REGISTER_URL' => 'http://shipping.mercadopago.com.mx/optin/doOptin',
        'PUBLICKEY_URL' => 'https://www.mercadolibre.com/jms/mlm/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlm/account/credentials',
        'MP_SHIPPING_MIN_W' => 10,
        'MP_SHIPPING_MAX_W' => 80,
        'MP_SHIPPING_MIN_H' => 10,
        'MP_SHIPPING_MAX_H' => 80,
        'MP_SHIPPING_MIN_D' => 10,
        'MP_SHIPPING_MAX_D' => 120,
        'MP_SHIPPING_MIN_WE' => 100,
        'MP_SHIPPING_MAX_WE' => 30000,
        'ACCEPT_DIGITAL_CURRENCY' => true
    ),
    'MLB'          => array(
        'NAME' => 'Brasil',
        'CURRENCY' => 'BRL',
        'ISO' => 'BR',
        'BTN_COUNTRY' => 'Br',
        'UNIT_PRICE_TYPE' => 'FLOAT',
        'REGISTER_URL' => 'https://www.mercadopago.com/mlb/registration',
        'SECRET_URL' => 'https://www.mercadolibre.com/jms/mlb/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlb/ferramentas/aplicacoes',
        'IPN_URL' => 'https://www.mercadopago.com/mlb/ferramentas/notificacoes',
        'MPENVIOS_REGISTER_URL' => 'http://envios.mercadolivre.com.br/optin/doOptin',
        'PUBLICKEY_URL' => 'https://www.mercadolibre.com/jms/mlb/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlb/account/credentials',
        'MP_SHIPPING_MIN_W' => 16,
        'MP_SHIPPING_MAX_W' => 105,
        'MP_SHIPPING_MIN_H' => 11,
        'MP_SHIPPING_MAX_H' => 105,
        'MP_SHIPPING_MIN_D' => 2,
        'MP_SHIPPING_MAX_D' => 105,
        'MP_SHIPPING_MIN_WE' => 100,
        'MP_SHIPPING_MAX_WE' => 15000,
        'ACCEPT_DIGITAL_CURRENCY' => false
    ),
    'MLC'          => array(
        'NAME' => 'Chile',
        'CURRENCY' => 'CLP',
        'ISO' => 'CL',
        'BTN_COUNTRY' => 'Cl',
        'UNIT_PRICE_TYPE' => 'INTEGER',
        'REGISTER_URL' => 'https://www.mercadopago.com/mlc/registration',
        'SECRET_URL' => 'https://www.mercadolibre.com/jms/mlc/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlc/herramientas/aplicaciones',
        'IPN_URL' => 'https://www.mercadopago.com/mlc/herramientas/notificaciones',
        'PUBLICKEY_URL' => 'https://www.mercadolibre.com/jms/mlc/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlc/account/credentials',
        'ACCEPT_DIGITAL_CURRENCY' => false
    ),
    'MLV'          => array(
        'NAME' => 'Venezuela',
        'CURRENCY' => 'VEF',
        'ISO' => 'VE',
        'BTN_COUNTRY' => 'Ve',
        'UNIT_PRICE_TYPE' => 'INTEGER',
        'REGISTER_URL' => 'https://www.mercadopago.com/mlv/registration',
        'SECRET_URL' => 'https://www.mercadolibre.com/jms/mlv/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlv/herramientas/aplicaciones',
        'IPN_URL' => 'https://www.mercadopago.com/mlv/herramientas/notificaciones',
        //'PUBLICKEY_URL' => 'https://www.mercadolibre.com/jms/mlv/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlv/account/credentials',
        'ACCEPT_DIGITAL_CURRENCY' => false
    ),
    'MCO'          => array(
        'NAME' => 'Colombia',
        'CURRENCY' => 'COP',
        'ISO' => 'CO',
        'BTN_COUNTRY' => 'Co',
        'UNIT_PRICE_TYPE' => 'INTEGER',
        'REGISTER_URL' => 'https://www.mercadopago.com/mco/registration',
        'SECRET_URL' => 'https://www.mercadolibre.com/jms/mco/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mco/herramientas/aplicaciones',
        'IPN_URL' => 'https://www.mercadopago.com/mco/herramientas/notificaciones',
        'PUBLICKEY_URL' => 'https://www.mercadolibre.com/jms/mco/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mco/account/credentials',
        'ACCEPT_DIGITAL_CURRENCY' => false
    ),
    'MPE'          => array(
        'NAME' => 'Peru',
        'CURRENCY' => 'PEN',
        'ISO' => 'PE',
        'BTN_COUNTRY' => 'Pe',
        'UNIT_PRICE_TYPE' => 'FLOAT',
        'REGISTER_URL' => 'https://registration.mercadopago.com.pe/registration-mp?mode=mp',
        'SECRET_URL' => 'https://www.mercadolibre.com/jms/mpe/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mpe/account/credentials?type=basic',
        'IPN_URL' => 'https://www.mercadopago.com/mpe/herramientas/notificaciones',
        'PUBLICKEY_URL' => 'https://www.mercadolibre.com/jms/mpe/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mpe/account/credentials',
        'ACCEPT_DIGITAL_CURRENCY' => false
    ),
    'MLU'          => array(
        'NAME' => 'Uruguay',
        'CURRENCY' => 'UYU',
        'ISO' => 'UY',
        'BTN_COUNTRY' => 'Ur',
        'UNIT_PRICE_TYPE' => 'FLOAT',
        'REGISTER_URL' => 'https://registration.mercadopago.com.uy/registration-mp?mode=mp',
        'SECRET_URL' => 'https://www.mercadolibre.com/jms/mlu/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlu/account/credentials?type=basic',
        'IPN_URL' => 'https://www.mercadopago.com/mlu/herramientas/notificaciones',
        'PUBLICKEY_URL' => 'https://www.mercadolibre.com/jms/mlu/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlu/account/credentials',
        'ACCEPT_DIGITAL_CURRENCY' => false
    ),

);
